package com.bailuntec.job.service;

import com.bailuntec.api.bailuntec.pps.PpsApi;
import com.bailuntec.api.bailuntec.pps.request.GetListingSkuMapPagesReq;
import com.bailuntec.api.bailuntec.pps.response.GetListingSkuMapPagesItem;
import com.bailuntec.api.bailuntec.pps.response.PpsPage;
import com.bailuntec.api.bailuntec.pps.response.PpsResult;
import com.bailuntec.application.IDcBaseSkuMappingOnlineService;
import com.bailuntec.common.ListUtil;
import com.bailuntec.domain.DcBaseSkuMappingOnline;
import com.bailuntec.domain.DcJobConfig;
import com.bailuntec.infrastructure.mapper.DcJobConfigMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/10/7 11:38 上午
 */
@Slf4j
@Service
public class SkuService {

    @Resource
    DcJobConfigMapper dcJobConfigMapper;
    @Resource
    PpsApi ppsApi;
    @Resource
    IDcBaseSkuMappingOnlineService dcBaseSkuMappingOnlineService;

    private final static String baseSyncSkuMappingOnline = "base-sync-sku-mapping-online";

    public void syncSkuMappingOnline() {

        DcJobConfig dcJobConfig = dcJobConfigMapper.selectByName(baseSyncSkuMappingOnline);
        Integer currentPage = dcJobConfig.getPageNum();
        Integer pageSize = dcJobConfig.getPageSize();
        for (; ; ) {

            GetListingSkuMapPagesReq req = new GetListingSkuMapPagesReq();
            req.setPageIndex(currentPage);
            req.setPageNumber(pageSize);

            req.setBeginTime(dcJobConfig.getStartTime());
            req.setEndTime(dcJobConfig.getEndTime());

            PpsResult<PpsPage<GetListingSkuMapPagesItem>> result = ppsApi.getListingSkuMapPages(req);
            if (ListUtil.isEmpty(result.getResult().getData())) {
                break;
            }

            List<DcBaseSkuMappingOnline> dcBaseSkuMappingOnlineList = result.getResult().getData()
                    .stream()
                    .map(getListingSkuMapPagesItem -> getListingSkuMapPagesItem.getDetails()
                            .stream()
                            .map(getListingSkuMapPagesItemDetail -> {
                                DcBaseSkuMappingOnline dcBaseSkuMappingOnline = new DcBaseSkuMappingOnline();
                                //item
                                dcBaseSkuMappingOnline.setAccountId(getListingSkuMapPagesItem.getAccountId());
                                dcBaseSkuMappingOnline.setAccountName(getListingSkuMapPagesItem.getAccountName());
                                dcBaseSkuMappingOnline.setIsDeleted(getListingSkuMapPagesItem.getIsDeleted());
                                dcBaseSkuMappingOnline.setItemId(getListingSkuMapPagesItem.getItemId());
                                dcBaseSkuMappingOnline.setPlatform(getListingSkuMapPagesItem.getPlatform());
                                dcBaseSkuMappingOnline.setSite(getListingSkuMapPagesItem.getSite());

                                //detail
                                dcBaseSkuMappingOnline.setItemSku(getListingSkuMapPagesItemDetail.getItemSku());
                                dcBaseSkuMappingOnline.setSkuCode(getListingSkuMapPagesItemDetail.getSkuCode());
                                return dcBaseSkuMappingOnline;
                            })
                            .collect(Collectors.toList()))

                    .flatMap(List::stream)
                    .collect(Collectors.toList());

            dcBaseSkuMappingOnlineService.saveBatch(dcBaseSkuMappingOnlineList);
        }
        dcJobConfigMapper.updateById(dcJobConfig.refresh());
    }
}
