package com.bailuntec.job;


import com.bailuntec.job.service.SkuService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

@Slf4j
@Component
public class SkuJob {

    @Resource
    SkuService skuService;

    @Scheduled(cron = "0/10 * * * * ?")
    public void syncSkuMappingOnline() {
        try {
            log.info("每10秒同步线上sku映射 开始");
            skuService.syncSkuMappingOnline();
            log.info("每10秒同步线上sku映射 结束");
        } catch (Exception ex) {
            log.error("每10秒同步线上sku映射 异常:", ex);
        }
    }


}
