package com.bailuntec.infrastructure.mapper;

import com.bailuntec.domain.DcPlatformBalance;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * <p>
 * 平台账号余额表 Mapper 接口
 * </p>
 *
 * @author robbendev
 * @since 2020-11-03
 */
public interface DcPlatformBalanceMapper extends BaseMapper<DcPlatformBalance> {

    @Select("select ifnull(sum(amount_rmb),0) amount_rmb from dc_platform_balance where delstatus=0 and day = #{lastDay}")
    BigDecimal getPlatformBalanceSum(@Param("lastDay") LocalDate lastDay);

    @Update("update dc_platform_balance b left join dc_exchange_rate r on b.day = r.record_time and b.currency = r.init_curreny and r.final_curreny = 'CNY' " +
            "set b.exchangerate = r.exchange_rate, b.amount_rmb = b.amount * r.exchange_rate, b.userable_amount_rmb = b.userable_amount * r.exchange_rate " +
            "where b.fromsource = 'paypal' and b.platformcode = 'Ebay' and b.day = #{lastDay}")
    void updatePayPalBalance(LocalDate lastDay);
}
