package com.bailuntec.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * SKU调拨单入库总数表
 * </p>
 *
 * @author robbendev
 * @since 2020-08-19
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="DcBaseTransferInbound对象", description="SKU调拨单入库总数表")
public class DcBaseTransferInbound implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "数据中心创建时间")
    private LocalDateTime gmtCreate;

    @ApiModelProperty(value = "数据中心更新时间")
    private LocalDateTime gmtModified;

    @ApiModelProperty(value = "百伦SKU")
    private String bailunSku;

    @ApiModelProperty(value = "调拨单号")
    private String transferOrderId;

    @ApiModelProperty(value = "调拨目的仓库编码")
    private String warehouseCode;

    @ApiModelProperty(value = "调拨目的仓库名称")
    private String warehouseName;

    @ApiModelProperty(value = "入库状态")
    private String status;

    @ApiModelProperty(value = "调拨系统创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "调拨数量--入库的是总数,不是流水")
    private Integer count;

    @ApiModelProperty(value = "SKU标题")
    private String skuTitle;

    @ApiModelProperty(value = "调拨系统主键")
    private Integer transferKey;

    @ApiModelProperty(value = "是否被删除")
    private Boolean deleted;

    @ApiModelProperty(value = "公司Id,0和1是百伦")
    private Integer companyId;

    @ApiModelProperty(value = "起始仓")
    private String sourceWarehouseCode;

    @ApiModelProperty(value = "是否异常")
    private Boolean isexception;


}
