package com.bailuntec.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * SKU采购入库信息表
 * </p>
 *
 * @author robbendev
 * @since 2020-08-19
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="DcBasePurchaseInbound对象", description="SKU采购入库信息表")
public class DcBasePurchaseInbound implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    private LocalDateTime gmtCreate;

    private LocalDateTime gmtModified;

    private String bailunSku;

    @ApiModelProperty(value = "入库单号")
    private String inboundId;

    @ApiModelProperty(value = "采购单号")
    private String purchaseId;

    @ApiModelProperty(value = "采购仓库编码")
    private String warehouseCode;

    @ApiModelProperty(value = "采购仓库名称")
    private String warehouseName;

    @ApiModelProperty(value = "入库状态")
    private String status;

    @ApiModelProperty(value = "采购系统创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "采购系统更新时间")
    private LocalDateTime updateTime;

    @ApiModelProperty(value = "入库数量")
    private Integer count;

    private String skuName;

    @ApiModelProperty(value = "1是调拨的")
    private Integer hasTransfer;

    private Integer parentId;

    @ApiModelProperty(value = "公司Id,0和1是百伦")
    private Integer companyId;


}
