package com.bailuntec.task.reader;

import com.bailuntec.common.ListUtil;
import com.bailuntec.domain.DcBaseCompanyAccount;
import com.bailuntec.infrastructure.mapper.DcBaseCompanyAccountMapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import org.springframework.batch.item.ItemReader;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2021/1/21 4:44 下午
 */
@Component
public class CustomerReader implements ItemReader<DcBaseCompanyAccount> {

    @Resource
    DcBaseCompanyAccountMapper dcBaseCompanyAccountMapper;

    private List<DcBaseCompanyAccount> dcBaseCompanyAccountList;

    @PostConstruct
    void init() {
        dcBaseCompanyAccountList = dcBaseCompanyAccountMapper.selectList(new LambdaQueryWrapper<DcBaseCompanyAccount>()
                .eq(DcBaseCompanyAccount::getPlatformId, DcBaseCompanyAccount.EBAY_PLATFORM_ID)
                .eq(DcBaseCompanyAccount::getStatus, DcBaseCompanyAccount.STATUS_ON));
    }

    public DcBaseCompanyAccount read() {
        if (ListUtil.isNotEmpty(dcBaseCompanyAccountList)) {
            return dcBaseCompanyAccountList.remove(0);
        }
        return null;
    }
}
