package com.bailuntec.task.processor;

import com.bailuntec.api.bailuntec.oa.OaApi;
import com.bailuntec.common.JsonUtilByFsJson;
import com.bailuntec.domain.DcBaseCompanyAccount;
import com.bailuntec.domain.DcBaseFinanceEbay;
import com.bailuntec.infrastructure.util.enumerate.CurrencyType;
import com.bailuntec.task.config.JobProperty;
import com.bailuntec.task.reader.EbayItem;
import com.ebay.soap.eBLBaseComponents.AccountEntryType;
import lombok.extern.slf4j.Slf4j;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneId;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2021/1/21 5:01 下午
 */
@Slf4j
@Component
public class CustomerProcessor implements ItemProcessor<EbayItem, DcBaseFinanceEbay> {

    @Resource
    private JobProperty jobProperty;
    @Resource
    private OaApi oaApi;


    @Override
    public DcBaseFinanceEbay process(@NonNull EbayItem ebayItem) throws Exception {
        DcBaseFinanceEbay dcBaseFinanceEbay = new DcBaseFinanceEbay();

        AccountEntryType accountEntryType = ebayItem.getAccountEntryType();
        DcBaseCompanyAccount dcBaseCompanyAccount = ebayItem.getDcBaseCompanyAccount();

        ZoneId zone = ZoneId.systemDefault();
        LocalDateTime gmt = LocalDateTime.ofInstant(accountEntryType.getDate().getTime().toInstant(), zone);

        dcBaseFinanceEbay.setGmtDate(gmt);
        dcBaseFinanceEbay.setBjDate(dcBaseFinanceEbay.getGmtDate().minusHours(15L));
        dcBaseFinanceEbay.setAccountEntryType(accountEntryType.getAccountDetailsEntryType() == null ? "" : accountEntryType.getAccountDetailsEntryType().value());
        dcBaseFinanceEbay.setVatPercent(accountEntryType.getVATPercent());
        dcBaseFinanceEbay.setItemId(accountEntryType.getItemID());
        dcBaseFinanceEbay.setTransactionId(accountEntryType.getTransactionID());
        dcBaseFinanceEbay.setOrderLineId(accountEntryType.getOrderLineItemID());
        dcBaseFinanceEbay.setReceivedTopRatedDiscount(accountEntryType.isReceivedTopRatedDiscount());
        dcBaseFinanceEbay.setDescription(accountEntryType.getDescription());
        dcBaseFinanceEbay.setMemo(accountEntryType.getMemo());
        dcBaseFinanceEbay.setRefNumber(accountEntryType.getRefNumber());
        dcBaseFinanceEbay.setTitle(accountEntryType.getTitle());
        dcBaseFinanceEbay.setReportDate(ebayItem.getEbayAccountReportTask().getEndTime().toLocalDate());
        if (accountEntryType.getGrossDetailAmount() != null) {
            dcBaseFinanceEbay.setGrossAmount(BigDecimal.valueOf(accountEntryType.getGrossDetailAmount().getValue()));
            dcBaseFinanceEbay.setCurrency(accountEntryType.getGrossDetailAmount().getCurrencyID().value());

            dcBaseFinanceEbay.setExchangeRate(oaApi.getExchangeRateByCurAndDate(dcBaseFinanceEbay.getCurrency(), CurrencyType.CNY.value(), dcBaseFinanceEbay.getBjDate().toLocalDate()).getRate());
            dcBaseFinanceEbay.setExchangeRateUsd(oaApi.getExchangeRateByCurAndDate(dcBaseFinanceEbay.getCurrency(), CurrencyType.USD.value(), dcBaseFinanceEbay.getBjDate().toLocalDate()).getRate());
        }
        if (accountEntryType.getGrossDetailAmount() != null) {
            dcBaseFinanceEbay.setNetAmount(BigDecimal.valueOf(accountEntryType.getGrossDetailAmount().getValue()));
        }
        dcBaseFinanceEbay.setAccountId(dcBaseCompanyAccount.getAccountId());
        dcBaseFinanceEbay.setCompanyId(dcBaseCompanyAccount.getCompanyId());
        dcBaseFinanceEbay.setBjModified(LocalDateTime.now());

        log.debug(JsonUtilByFsJson.beanToJson(dcBaseFinanceEbay));
        return dcBaseFinanceEbay;
    }
}
