package com.bailuntec.job.service;

import com.bailuntec.BalanceSheetApp;
import com.bailuntec.domain.DcJobConfig;
import com.bailuntec.infrastructure.mapper.DcJobConfigMapper;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.context.web.WebAppConfiguration;

import javax.annotation.Resource;
import java.text.ParseException;
import java.util.Date;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/11/3 5:10 下午
 */
@ActiveProfiles("test")
@RunWith(SpringRunner.class)
@SpringBootTest(classes = BalanceSheetApp.class)
@WebAppConfiguration
public class BalanceSheetServiceTest {

    @Resource
    BalanceSheetService balanceSheetService;

    @Resource
    DcJobConfigMapper dcJobConfigMapper;

    @Test
    public void syncBankAccount() {
        balanceSheetService.syncBankAccount();
    }

    @Test
    public void syncWithdrawOnWaySummary() {
        balanceSheetService.syncWithdrawOnWaySummary();
    }

    @Test
    public void syncShortBorrowBalance() {
        balanceSheetService.syncShortBorrowBalance();
    }

    @Test
    public void syncCost() {
        balanceSheetService.syncCost();
    }

    @Test
    public void syncBuy() throws ParseException {
        balanceSheetService.syncBuy();
    }

    @Test
    public void generateBalanceSheet() {
        balanceSheetService.generateBalanceSheet();
    }

    @Test
    public void test(){
        /*System.out.println("----------------------------------");
        DcJobConfig dcJobConfig = dcJobConfigMapper.selectByName("finance-generate-balance-sheet");
        dcJobConfig.setStartTime(LocalDateTime.of(2021,3,18,0,0));
        balanceSheetService.getSemiInventoryBalance(dcJobConfig);*/
        DcJobConfig dcJobConfig = dcJobConfigMapper.selectByName("finance-generate-balance-sheet");
        //Date lastDay = Date.from(dcJobConfig.getStartTime().toInstant(ZoneOffset.ofHours(8)));
        dcJobConfig.setStartTime(dcJobConfig.getStartTime().plusHours(-5));
        Date lastDay = java.sql.Date.valueOf(dcJobConfig.getStartTime().toLocalDate());
        System.out.println(lastDay);
    }
}
