package com.bailuntec.infrastructure.mapper;

import com.bailuntec.domain.DcBankAccountBalance;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * <p>
 * 银行账户余额 Mapper 接口
 * </p>
 *
 * @author robbendev
 * @since 2020-11-03
 */
public interface DcBankAccountBalanceMapper extends BaseMapper<DcBankAccountBalance> {

    @Delete("delete b from dc_bank_account_balance b inner join dc_company_main_body c on b.company_value = c.company_value and c.no_monetary_fund = 1 " +
            "where b.statistical_time = #{lastDay}")
    void deleteUnusedData(@Param("lastDay") LocalDate lastDay);

    @Delete("delete from dc_bank_account_balance where company_value = 2 and bank_name in ('paypal','payoneer') and statistical_time = #{lastDay}")
    void deleteUnusedData1(@Param("lastDay") LocalDate lastDay);

    @Delete("delete from dc_bank_account_balance where company_value = 0 and statistical_time = #{lastDay}")
    void deleteUnusedData2(@Param("lastDay") LocalDate lastDay);

    /**
     * 查询银行余额总和
     *
     * @param lastDay 日期
     * @return 余额总和
     */
    BigDecimal getBalanceSum(@Param("lastDay") LocalDate lastDay);
}
