package com.bailuntec.infrastructure.common;

import com.bailuntec.domain.DcJobConfig;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/12/11 4:42 下午
 */
@Data
public class BaseJobSqlParam {

    private LocalDateTime startTime;
    private LocalDateTime endTime;
    private Integer pageStart;
    private Integer pageOffset;


    public BaseJobSqlParam() {

    }

    public BaseJobSqlParam(DcJobConfig dcJobConfig) {
        this.startTime = dcJobConfig.getStartTime().minusMinutes(3);
        this.endTime = dcJobConfig.getEndTime();
        this.pageStart = (dcJobConfig.getPageNum() - 1) * dcJobConfig.getPageSize();
        this.pageOffset = dcJobConfig.getPageSize();
    }

    public static BaseJobSqlParam newInstance(DcJobConfig dcJobConfig) {
        return new BaseJobSqlParam(dcJobConfig);
    }
}
