package com.bailuntec.domain;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * SKU采购信息表
 * </p>
 *
 * @author robbendev
 * @since 2020-08-19
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="DcBasePurchase对象", description="SKU采购信息表")
public class DcBasePurchase implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    private LocalDateTime gmtCreate;

    private LocalDateTime gmtModified;

    private String bailunSku;

    @ApiModelProperty(value = "采购单号")
    private String purchaseId;

    @ApiModelProperty(value = "仓库编码")
    private String warehouseCode;

    @ApiModelProperty(value = "仓库名称")
    private String warehouseName;

    @ApiModelProperty(value = "状态-1：作废，0：待确认，1：已确认 4：已完成")
    private String status;

    @ApiModelProperty(value = "采购系统创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "采购系统更新时间")
    private LocalDateTime updateTime;

    @ApiModelProperty(value = "数量")
    private Integer count;

    @ApiModelProperty(value = "1是调拨的")
    private Integer hasTransfer;

    @ApiModelProperty(value = "SKU名称")
    private String skuName;

    @ApiModelProperty(value = "预计到达时间")
    private LocalDateTime estimatedArrivalTime;

    @ApiModelProperty(value = "供应商ID")
    private Integer supplierId;

    @ApiModelProperty(value = "供应商名称")
    private String supplierName;

    @ApiModelProperty(value = "采购单确认时间")
    private LocalDateTime confirmTime;

    @ApiModelProperty(value = "采购单付款时间")
    private LocalDateTime payTime;

    @ApiModelProperty(value = "1 = 先款后货  2 = 先货后款")
    private Integer payType;

    @ApiModelProperty(value = "采购单价")
    private BigDecimal price;

    @ApiModelProperty(value = "采购单状态 0待确认, 1已确认,2主管已审核3,发货入库中,4：采购完成, -2拆分订单, -1作废")
    private Integer buyStatus;

    @ApiModelProperty(value = "发货交通类型")
    private Integer transportType;

    @ApiModelProperty(value = "采购系统的供应商ID")
    private Integer deliverId;

    @ApiModelProperty(value = "采购单父Id")
    private Integer parentId;

    @ApiModelProperty(value = "1是删除的")
    private Integer hasDelete;

    @ApiModelProperty(value = "公司Id,0和1是百伦")
    private Integer companyId;


}
