package com.bailuntec.infrastructure.mapper;

import com.bailuntec.domain.DcSemiDailyTransfer;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * <p>
 * 半成品每天采购在途 Mapper 接口
 * </p>
 *
 * @author robbendev
 * @since 2020-11-11
 */
public interface DcSemiDailyTransferMapper extends BaseMapper<DcSemiDailyTransfer> {

    @Select("select ifnull(sum(transfer_quantity * unit_price),0) from dc_semi_daily_transfer where day = #{lastDay}")
    BigDecimal getSemiDailyTransferSum(@Param("lastDay") LocalDate lastDay);

    @Select("select ifnull(sum(transfer_quantity * unit_price),0) from dc_semi_daily_transfer where day = #{lastDay} and warehouse_id in (27,1,26,5,17,15,19,18,2)")
    BigDecimal getSemiBailunDailyTransferSum(@Param("lastDay") LocalDate lastDay);

    @Select("select ifnull(sum(transfer_quantity * unit_price),0) from dc_semi_daily_transfer where day = #{lastDay} and warehouse_id in (16,9)")
    BigDecimal getSemiHaNiDailyTransferSum(@Param("lastDay") LocalDate lastDay);

    @Insert("<script>" +
            "insert ignore into dc_semi_daily_transfer(day,buy_id,detail_id,buy_no,supplier_id,supplier_name,sku_code,sku_name,warehouse_id,warehouse_name,transfer_quantity,unit_price,semi_update_date) " +
            "select #{lastDay},buy_id,detail_id,buy_no,supplier_id,supplier_name,sku_code,sku_name,warehouse_id,warehouse_name,transfer_quantity,unit_price,semi_update_date " +
            "from dc_semi_purchase_detail where transfer_quantity > 0 and sku_del_status=0 and purchase_del_status=0" +
            "</script>")
    void insertSemiDailyTransfer(@Param("lastDay") LocalDate lastDay);
}
