package com.bailuntec.task;

import org.springframework.batch.core.configuration.annotation.EnableBatchProcessing;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.cloud.task.configuration.EnableTask;
import org.springframework.context.annotation.ComponentScan;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2021/1/21 4:36 下午
 */

@EnableBatchProcessing
@EnableTask
@SpringBootApplication
@ComponentScan("com.bailuntec")
@EnableFeignClients(basePackages = {"com.bailuntec.api", "com.bailuntec.*.api"})
public class EbayReportProduceTaskApp {
    public static void main(String[] args) {
        SpringApplication.run(EbayReportProduceTaskApp.class, args);
    }
}
