package com.bailuntec.domain;

import com.alibaba.fastjson.annotation.JSONField;
import com.bailuntec.api.ebay.seller.response.transaction.Amount;
import com.bailuntec.api.ebay.seller.response.transaction.Reference;
import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @Author: li.yanlin
 * @Description：
 * @Date: Created in  2021-05-20
 * @Modified by:
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="DcBaseEbayTransaction对象", description="")
public class DcBaseEbayTransaction implements Serializable {

    private String id;

    private String value;

    private String currency;

    @ApiModelProperty("在此字段中返回的枚举值指示货币交易金额是卖方帐户的（CREDIT）还是（DEBIT）。 通常，SALE和CREDIT交易类型记入卖方帐户，而REFUND，DISPUTE，SHIPPING_LABEL和TRANSFER交易类型记入卖方帐户的借方。")
    private String bookingEntry;

    private String username;

    private String feeType;

    private String orderId;

    //private List<OrderLineItem> orderLineItems;

    @ApiModelProperty("此字符串值指示正在处理付款的实体。")
    private String paymentsEntity;

    private String payoutId;

    private String referencesJson;

    private String itemId;

    @ApiModelProperty("与销售订单关联的销售记录号。销售记录号是在结帐时创建的Selling Manager / Selling Manager Pro标识符。")
    private String salesRecordReference;

    @JSONField(format = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")
    private LocalDateTime transactionDate;

    private LocalDate transactionDateShort;

    private String transactionId;

    private String transactionMemo;

    private String transactionStatus;

    private String transactionType;

    private Integer accountId;

    @TableField(exist = false)
    private List<Reference> references;

    @TableField(exist = false)
    @ApiModelProperty("该金额是在从与订单相关的卖方付款中扣除销售费用之前的订单总金额。要确定将通过卖方付款支付的订单的实际金额，请从basePayoutAmount中减去totalFeeAmount。")
    private Amount totalFeeBasisAmount;

    @TableField(exist = false)
    private Amount totalFeeAmount;
}
