package com.bailuntec.job;

import com.bailuntec.domain.DcBaseFinanceEbay;
import com.bailuntec.infrastructure.mapper.DcBaseCompanyAccountMapper;
import com.bailuntec.infrastructure.mapper.DcJobConfigMapper;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.configuration.annotation.EnableBatchProcessing;
import org.springframework.batch.core.configuration.annotation.JobBuilderFactory;
import org.springframework.batch.core.configuration.annotation.StepBuilderFactory;
import org.springframework.batch.core.launch.support.RunIdIncrementer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import javax.batch.api.listener.JobListener;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2021/1/19 1:37 下午
 */
@Configuration
@EnableBatchProcessing
public class JobConfiguration {

    public final JobBuilderFactory jobBuilderFactory;
    public final StepBuilderFactory stepBuilderFactory;
    private final EbayItemReader ebayItemReader;
    private final EbayItemProcessor ebayItemProcessor;
    private final EbayFinanceWriter ebayFinanceWriter;

    private final DcBaseCompanyAccountMapper dcBaseCompanyAccountMapper;
    private final DcJobConfigMapper dcJobConfigMapper;


    @Autowired
    public JobConfiguration(JobBuilderFactory jobBuilderFactory, StepBuilderFactory stepBuilderFactory, EbayItemReader ebayItemReader, EbayItemProcessor ebayItemProcessor, EbayFinanceWriter ebayFinanceWriter, JobListener jobListener, DcBaseCompanyAccountMapper dcBaseCompanyAccountMapper, DcJobConfigMapper dcJobConfigMapper) {
        this.jobBuilderFactory = jobBuilderFactory;
        this.stepBuilderFactory = stepBuilderFactory;
        this.ebayItemReader = ebayItemReader;
        this.ebayItemProcessor = ebayItemProcessor;
        this.ebayFinanceWriter = ebayFinanceWriter;
        this.dcBaseCompanyAccountMapper = dcBaseCompanyAccountMapper;
        this.dcJobConfigMapper = dcJobConfigMapper;
    }

    @Bean
    EbayItemReader reader() {
        return new EbayItemReader(dcBaseCompanyAccountMapper, dcJobConfigMapper);
    }

    @Bean
    public Job dataHandleJob() {
        return jobBuilderFactory.get("dataHandleJob")
                .incrementer(new RunIdIncrementer())
                .start(handleDataStep())   //start是JOB执行的第一个step
//                ...
                .build();
    }

    @Bean
    public Step handleDataStep() {
        return stepBuilderFactory.get("getData")
                .<EbayItem, DcBaseFinanceEbay>chunk(100)        // <输入,输出> 。chunk通俗的讲类似于SQL的commit; 这里表示处理(processor)100条后写入(writer)一次。
                .reader(reader())         //指定ItemReader
                .processor(ebayItemProcessor)   //指定ItemProcessor
                .writer(ebayFinanceWriter)       //指定ItemWriter
                .build();
    }

}
