package com.bailuntec.job;

import com.bailuntec.application.IDcBaseFinanceEbayService;
import com.bailuntec.domain.DcBaseFinanceEbay;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2021/1/19 1:21 下午
 */
public class EbayFinanceWriter implements ItemWriter<DcBaseFinanceEbay> {

    final IDcBaseFinanceEbayService dcBaseFinanceEbayService;

    public EbayFinanceWriter(IDcBaseFinanceEbayService dcBaseFinanceEbayService) {
        this.dcBaseFinanceEbayService = dcBaseFinanceEbayService;
    }

    @Override
    public void write(@NonNull List<? extends DcBaseFinanceEbay> items) throws Exception {
        dcBaseFinanceEbayService.saveBatch(items.stream().map(var -> (DcBaseFinanceEbay) var).collect(Collectors.toList()));
    }
}
