package com.bailuntec.job.service;

import com.bailuntec.api.bailuntec.cw.CwApi;
import com.bailuntec.api.bailuntec.cw.response.GetCashiersResp;
import com.bailuntec.api.bailuntec.cw.response.GetHandleFeeTradeRecordsResp;
import com.bailuntec.api.bailuntec.cw.response.GetRepayPlanDetailsResp;
import com.bailuntec.api.bailuntec.cw.response.GetWithdrawDetailPagesResp;
import com.bailuntec.application.IDcBaseFinanceCashierService;
import com.bailuntec.application.IDcBaseFinanceCashierdetailService;
import com.bailuntec.application.IDcBaseFinanceHandlefeeService;
import com.bailuntec.application.IDcBaseFinanceInterestService;
import com.bailuntec.common.BeanUtils;
import com.bailuntec.common.ListUtil;
import com.bailuntec.domain.*;
import com.bailuntec.infrastructure.mapper.DcJobConfigMapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/10/7 11:38 上午
 */
@Slf4j
@Service
public class SyncCashierService {

    @Resource
    private CwApi cwApi;
    @Resource
    private DcJobConfigMapper dcJobConfigMapper;
    @Resource
    IDcBaseFinanceCashierService dcBaseFinanceCashierService;
    @Resource
    IDcBaseFinanceCashierdetailService dcBaseFinanceCashierdetailService;
    @Resource
    IDcBaseFinanceHandlefeeService dcBaseFinanceHandlefeeService;

    private static final String baseSyncCashier = "base-sync-cashier";
    private static final String baseSyncWithdraw = "base-sync-withdraw";
    private static final String baseSyncSalesPlatform = "base-sync-sales-platform";
    private static final String baseSyncInterest = "base-sync-interest";
    private static final String baseSyncHandlefee = "base-sync-handle-fee";


    @Transactional
    public void syncCashier() {
        DcJobConfig dcJobConfig = dcJobConfigMapper.selectByName(baseSyncCashier);
        Integer currentPage = 1;
        Integer pageSize = 100;
        for (; ; ) {
            log.info("请求费用流水 开始");
            List<GetCashiersResp> resp = cwApi.getCashiers(pageSize, dcJobConfig.getStartTimeStr(), dcJobConfig.getEndTimeStr(), currentPage);
            if (ListUtil.isEmpty(resp)) {
                break;
            }
            resp.forEach(getCashiersResp -> {
                DcBaseFinanceCashier dcBaseFinanceCashier = new DcBaseFinanceCashier();
                BeanUtils.copyProperties(getCashiersResp, dcBaseFinanceCashier);

                LambdaQueryWrapper<DcBaseFinanceCashier> wrapper = new LambdaQueryWrapper<DcBaseFinanceCashier>()
                        .eq(DcBaseFinanceCashier::getId, dcBaseFinanceCashier.getId());

                //更新失败就插入
                if (dcBaseFinanceCashierService.saveOrUpdate(dcBaseFinanceCashier, wrapper)) {
                    log.info("同步一条费用流水，出纳编号:{}", dcBaseFinanceCashier.getCode());
                } else {
                    log.error("同步费用失败,出纳编号:{}", dcBaseFinanceCashier.getCode());
                }
            });
            log.info("请求费用流水 结束");
            currentPage++;
        }
        dcJobConfigMapper.updateById(dcJobConfig.refresh());
    }

    @Transactional
    public void syncWithdraw() {
        DcJobConfig dcJobConfig = dcJobConfigMapper.selectByName(baseSyncWithdraw);
        Integer currentPage = 1;
        Integer pageSize = 100;
        for (; ; ) {
            log.info("请求费用流水详情 开始");
            GetWithdrawDetailPagesResp resp = cwApi.getWithdrawDetailPages(pageSize, dcJobConfig.getStartTimeStr(), dcJobConfig.getEndTimeStr(), currentPage);
            if (ListUtil.isEmpty(resp.getList())) {
                break;
            }
            resp.getList().forEach(getWithdrawDetailPagesItem -> {
                DcBaseFinanceCashierdetail dcBaseFinanceCashierdetail = new DcBaseFinanceCashierdetail();
                BeanUtils.copyProperties(getWithdrawDetailPagesItem, dcBaseFinanceCashierdetail);

                LambdaQueryWrapper<DcBaseFinanceCashierdetail> updateWrapper = new LambdaQueryWrapper<DcBaseFinanceCashierdetail>()
                        .eq(DcBaseFinanceCashierdetail::getCwId, dcBaseFinanceCashierdetail.getCwId());

                //更新失败就插入
                if (dcBaseFinanceCashierdetailService.saveOrUpdate(dcBaseFinanceCashierdetail, updateWrapper)) {
                    log.info("同步一条费用流水详情，唯一id:{}", dcBaseFinanceCashierdetail.getCwId());
                } else {
                    log.error("同步费用详情失败,唯一id:{}", dcBaseFinanceCashierdetail.getCwId());
                }
            });
            log.info("请求费用流水详情 结束");
            currentPage++;
        }
        dcJobConfigMapper.updateById(dcJobConfig.refresh());
    }

    @Resource
    IDcBaseFinanceInterestService dcBaseFinanceInterestService;

    @Transactional
    public void syncInterest() {

        DcJobConfig dcJobConfig = dcJobConfigMapper.selectByName(baseSyncInterest);

        log.info("请求利息支出接口同步百伦接口 开始");
        List<GetRepayPlanDetailsResp> resp = cwApi.getRepayPlanDetails(dcJobConfig.getStartTimeStr(), dcJobConfig.getEndTimeStr());

        resp.forEach(getHandleFeeTradeRecordsResp -> {

            LambdaQueryWrapper<DcBaseFinanceInterest> wrapper = new LambdaQueryWrapper<DcBaseFinanceInterest>()
                    .eq(DcBaseFinanceInterest::getBorrowId, getHandleFeeTradeRecordsResp.getBorrowId())
                    .eq(DcBaseFinanceInterest::getRepayId, getHandleFeeTradeRecordsResp.getRepayId())
                    .eq(DcBaseFinanceInterest::getContractNo, getHandleFeeTradeRecordsResp.getContractNo());

            DcBaseFinanceInterest dcBaseFinanceInterest = dcBaseFinanceInterestService.getOne(wrapper);
            if (dcBaseFinanceInterest == null) {
                dcBaseFinanceInterest = new DcBaseFinanceInterest();
                BeanUtils.copyProperties(getHandleFeeTradeRecordsResp, dcBaseFinanceInterest, "id");
            }
            dcBaseFinanceInterest.setGmtModify(LocalDateTime.now());
            dcBaseFinanceInterestService.saveOrUpdate(dcBaseFinanceInterest);

            log.info("同步一利息支出，borrow id:{}", dcBaseFinanceInterest.getBorrowId());
        });
        log.info("请求利息支出接口同步百伦接口 结束");

        dcJobConfigMapper.updateById(dcJobConfig.refresh());
    }

    @Transactional
    public void syncHandleFee() {

        DcJobConfig dcJobConfig = dcJobConfigMapper.selectByName(baseSyncHandlefee);

        log.info("请求财务手续费接口 开始");
        List<GetHandleFeeTradeRecordsResp> resp = cwApi.getHandleFeeTradeRecords(dcJobConfig.getStartTimeStr(), dcJobConfig.getEndTimeStr());

        resp.forEach(getHandleFeeTradeRecordsResp -> {
            DcBaseFinanceHandlefee dcBaseFinanceHandlefee = new DcBaseFinanceHandlefee();
            BeanUtils.copyProperties(getHandleFeeTradeRecordsResp, dcBaseFinanceHandlefee);

            LambdaQueryWrapper<DcBaseFinanceHandlefee> updateWrapper = new LambdaQueryWrapper<DcBaseFinanceHandlefee>()
                    .eq(DcBaseFinanceHandlefee::getCwId, dcBaseFinanceHandlefee.getCwId());

            //更新失败就插入
            if (dcBaseFinanceHandlefeeService.saveOrUpdate(dcBaseFinanceHandlefee, updateWrapper)) {
                log.info("同步一条财务手续费，财务id:{}", dcBaseFinanceHandlefee.getCwId());
            } else {
                log.error("同步财务手续费,财务id:{}", dcBaseFinanceHandlefee.getCwId());
            }
        });
        log.info("请求财务手续费接口 结束");

        dcJobConfigMapper.updateById(dcJobConfig.refresh());
    }
}
