package com.bailuntec.infrastructure.mapper;

import com.bailuntec.domain.DcBaseFinanceFee;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;

import java.time.LocalDate;

/**
 * <p>
 * Mapper 接口
 * </p>
 *
 * @author robbendev
 * @since 2020-08-19
 */
public interface DcBaseFinanceFeeMapper extends BaseMapper<DcBaseFinanceFee> {

    /**
     * 删除指定日期的费用单
     *
     * @param minusDays 指定日期
     */
    void deleteDailyFee(LocalDate minusDays);

    /**
     * 同步指定天借支未还/部分还款费用单到 dc_daily_fee
     *
     * @param minusDays 指定日期
     */
    void insertDailyFee(LocalDate minusDays);

    /**
     * 根据费用单号查询
     *
     * @param costNo 费用单号
     * @return res
     */
    DcBaseFinanceFee selectByCostNo(String costNo);
}
