package com.bailuntec.domain;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 银行账号平台提现在途表
 * </p>
 *
 * @author robbendev
 * @since 2020-11-03
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="DcWithdrawOnWay对象", description="银行账号平台提现在途表")
public class DcWithdrawOnWay implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "借款公司主体Value")
    private Integer companyValue;

    @ApiModelProperty(value = "销售平台ID")
    private Integer salePlatformId;

    @ApiModelProperty(value = "销售平台名称")
    private String salePlatform;

    @ApiModelProperty(value = "支付平台ID")
    private Integer platformId;

    @ApiModelProperty(value = "支付平台名称")
    private String platform;

    @ApiModelProperty(value = "银行账号ID")
    private Integer payAccountId;

    @ApiModelProperty(value = "银行账号/卡号")
    private String payAccount;

    @ApiModelProperty(value = "银行名称")
    private String bankName;

    @ApiModelProperty(value = "银行持卡人")
    private String bankCardUser;

    @ApiModelProperty(value = "银行账号余额,RMB")
    private BigDecimal amountRmb;

    @ApiModelProperty(value = "统计时间")
    private LocalDate statisticalTime;

    @ApiModelProperty(value = "取数时间")
    private LocalDateTime updateTime;


}
