package com.bailuntec.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * FBA共享仓优先级配置
 * </p>
 *
 * @author robbendev
 * @since 2020-08-19
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="DcBaseStockConfigFba对象", description="FBA共享仓优先级配置")
public class DcBaseStockConfigFba implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "平台SKU,每个平台SKU只能有一个优先仓库")
    private String platformSku;

    @ApiModelProperty(value = "百伦SKU")
    private String bailunSku;

    @ApiModelProperty(value = "仓库编码")
    private String warehouseCode;

    @ApiModelProperty(value = "仓库名称")
    private String warehouseName;

    @ApiModelProperty(value = "数据中心-创建时间")
    private LocalDateTime gmtCreate;

    @ApiModelProperty(value = "数据中心-更新时间")
    private LocalDateTime gmtModified;

    @ApiModelProperty(value = "操作员")
    private String blOperator;

    @ApiModelProperty(value = "公司Id,0和1是百伦")
    private Integer companyId;


}
