package com.bailuntec.domain;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 半成品每天库存
 * </p>
 *
 * @author robbendev
 * @since 2020-11-11
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="DcSemiDailyStock对象", description="半成品每天库存")
public class DcSemiDailyStock implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "统计日期")
    private LocalDateTime day;

    @ApiModelProperty(value = "库存金额")
    private BigDecimal inventoryAmount;

    @ApiModelProperty(value = "原料sku编码")
    private String skuCode;

    @ApiModelProperty(value = "原料sku名称")
    private String skuName;

    @ApiModelProperty(value = "库存数量")
    private BigDecimal stockQuantity;

    @ApiModelProperty(value = "原料sku价格")
    private BigDecimal price;

    @ApiModelProperty(value = "仓库ID")
    private Integer warehouseId;

    @ApiModelProperty(value = "仓库名称")
    private String warehouseName;

    @ApiModelProperty(value = "冗余库存")
    private BigDecimal redundancyStock;

    @ApiModelProperty(value = "取数时间")
    private LocalDateTime updateTime;


}
