package com.bailuntec.domain;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 
 * </p>
 *
 * @author robbendev
 * @since 2020-08-19
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="DcBaseFinanceLogistics对象", description="")
public class DcBaseFinanceLogistics implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "费用单")
    private String no;

    @ApiModelProperty(value = "收款单位")
    private String receiveUnit;

    @ApiModelProperty(value = "收款银行")
    private String receiveBank;

    @ApiModelProperty(value = "收款帐号")
    private String receiveCard;

    @ApiModelProperty(value = "收款人")
    private String receiveCardUser;

    @ApiModelProperty(value = "付款理由")
    private String reason;

    @ApiModelProperty(value = "支付时间")
    private LocalDateTime payTime;

    @ApiModelProperty(value = "费用类 1付款  2收款  3借支/借还")
    private Integer manageCostType;

    @ApiModelProperty(value = "创建人所属部门")
    private String departmentName;

    @ApiModelProperty(value = "公司主体value")
    private String companyValue;

    @ApiModelProperty(value = "主体名称")
    private String companyName;

    @ApiModelProperty(value = "原管理成本表分类名")
    private String feeSuperType;

    @ApiModelProperty(value = "费用小类")
    private String feeSubType;

    @ApiModelProperty(value = "费用总金额")
    private BigDecimal amount;

    @ApiModelProperty(value = "币种")
    private String currency;

    @ApiModelProperty(value = "人民币总金额")
    private BigDecimal amountRmb;

    @ApiModelProperty(value = "费用单详情id")
    private Integer costId1;

    @ApiModelProperty(value = "费用单id")
    private Integer costId;

    @ApiModelProperty(value = "数据中心创建时间")
    private LocalDateTime gmtCreate;

    @ApiModelProperty(value = "数据中心更新时间")
    private LocalDateTime gmtModified;


}
