package com.bailuntec.job.service;

import com.bailuntec.BalanceSheetApp;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.junit4.SpringRunner;

import java.text.ParseException;
import java.time.LocalDate;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/11/3 5:10 下午
 */
@ActiveProfiles("test")
@RunWith(SpringRunner.class)
@SpringBootTest(classes = BalanceSheetApp.class)
public class BalanceSheetServiceTest {

    @Autowired
    private BalanceSheetService balanceSheetService;

    @Test
    public void syncBankAccount() {
        balanceSheetService.syncBankAccount();
    }

    @Test
    public void syncWithdrawOnWaySummary() {
        balanceSheetService.syncWithdrawOnWaySummary();
    }

    @Test
    public void syncShortBorrowBalance() {
        balanceSheetService.syncShortBorrowBalance();
    }

    @Test
    public void syncCost() {
        balanceSheetService.syncCost();
    }

    @Test
    public void syncBuy() throws ParseException {
        balanceSheetService.syncBuy();
    }

    @Test
    public void generateBalanceSheet() {
        balanceSheetService.generateBalanceSheet();
    }

    @Test
    public void test(){
        System.out.println(LocalDate.now().toString());
    }
}
