package com.bailuntec.domain;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 采购在途中间表
 * </p>
 *
 * @author robbendev
 * @since 2020-08-19
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="DcMidTransit对象", description="采购在途中间表")
public class DcMidTransit implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "SKU")
    private String bailunSku;

    @ApiModelProperty(value = "仓库编码")
    private String warehouseCode;

    @ApiModelProperty(value = "采购在途数量")
    private Integer quantityPurchase;

    @ApiModelProperty(value = "采购陆运在途数量")
    private Integer quantityLandPurchase;

    @ApiModelProperty(value = "采购海运在途数量")
    private Integer quantityOceanPurchase;

    @ApiModelProperty(value = "采购空运在途数量")
    private Integer quantityAirPurchase;

    @ApiModelProperty(value = "采购铁路在途数量")
    private Integer quantityRailwayPurchase;

    @ApiModelProperty(value = "采购在途数更新时间")
    private LocalDateTime gmtPurchaseModified;

    @ApiModelProperty(value = "调拨在途数量")
    private Integer quantityTransfer;

    @ApiModelProperty(value = "调拨在途总数量")
    private Integer quantityTransferOrder;

    @ApiModelProperty(value = "调拨在途 采购临时")
    private Integer quantityTransferTempSchedule;

    @ApiModelProperty(value = "调拨在途 暂存")
    private Integer quantityTransferTemporaryStorage;

    @ApiModelProperty(value = "调拨计划在途数量")
    private Integer quantityTransferPlan;

    @ApiModelProperty(value = "调拨陆运在途数量")
    private Integer quantityLandTransfer;

    @ApiModelProperty(value = "调拨海运在途数量")
    private Integer quantityOceanTransfer;

    @ApiModelProperty(value = "调拨空运在途数量")
    private Integer quantityAirTransfer;

    @ApiModelProperty(value = "调拨铁路在途数量")
    private Integer quantityRailwayTransfer;

    @ApiModelProperty(value = "调拨在途数更新时间")
    private LocalDateTime gmtTransferModified;

    @ApiModelProperty(value = "缺货数量")
    private Integer quantityOutStock;

    @ApiModelProperty(value = "缺货数更新时间")
    private LocalDateTime gmtOutStockModified;

    @ApiModelProperty(value = "未发货数量")
    private Integer quantityUnshipped;

    @ApiModelProperty(value = "未发货数更新时间")
    private LocalDateTime gmtUnshippedModified;

    @ApiModelProperty(value = "公司Id,0和1是百伦")
    private Integer companyId;

    @ApiModelProperty(value = "采购在途金额 = sum(采购单单价 * 采购单数量)")
    private BigDecimal amountPurchaseTransit;

    @ApiModelProperty(value = "未发货订单号")
    private String bailunOrderIds;

    @ApiModelProperty(value = "速卖通缺货")
    private Integer quantityOutStockAliexpress;

    @ApiModelProperty(value = "亚马逊缺货")
    private Integer quantityOutStockAmazon;

    @ApiModelProperty(value = "其他平台的需求")
    private Integer quantityOutStockOther;


}
