package com.bailuntec.domain;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 百伦OMS订单-订单维度
 * </p>
 *
 * @author robbendev
 * @since 2020-08-19
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="DcBaseOmsOrder对象", description="百伦OMS订单-订单维度")
public class DcBaseOmsOrder implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "平台订单号")
    private String originOrderId;

    @ApiModelProperty(value = "平台类型")
    private String platformType;

    @ApiModelProperty(value = "交易号")
    private String transactionId;

    @ApiModelProperty(value = "支付时间")
    private LocalDateTime payTime;

    @ApiModelProperty(value = "支付方法")
    private String payMethod;

    @ApiModelProperty(value = "支付账号")
    private String payAccount;

    @ApiModelProperty(value = "支付状态")
    private String payStatus;

    @ApiModelProperty(value = "收款账号")
    private String collectionAccount;

    @ApiModelProperty(value = "平台订单类型")
    private String platformOrderType;

    @ApiModelProperty(value = "站点")
    private String website;

    @ApiModelProperty(value = "订单百伦创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "订单创建时间")
    private LocalDateTime purchaseCreateTime;

    @ApiModelProperty(value = "是否有支付时间")
    private Boolean hasPaytime;

    @ApiModelProperty(value = "订单付款时间")
    private LocalDateTime paidTime;

    @ApiModelProperty(value = "订单退款时间")
    private LocalDateTime refundTime;

    @ApiModelProperty(value = "销售账号Id")
    private String sellerId;

    @ApiModelProperty(value = "账号id")
    private Integer bailunAccountId;

    @ApiModelProperty(value = "环球账号")
    private String hqAccount;

    @ApiModelProperty(value = "销售账号")
    private String sellerAccount;

    @ApiModelProperty(value = "暂时不知道意思")
    private String sellerOrderId;

    @ApiModelProperty(value = "销售账号邮箱")
    private String sellerEmail;

    @ApiModelProperty(value = "订单更新时间")
    private LocalDateTime orderUpdateTime;

    @ApiModelProperty(value = "百伦订单号")
    private String bailunOrderId;

    @ApiModelProperty(value = "平台订单状态")
    private String platformOrderStatus;

    @ApiModelProperty(value = "百伦订单状态")
    private String bailunOrderStatus;

    @ApiModelProperty(value = "百伦付款状态")
    private String bailunPaymentStatus;

    @ApiModelProperty(value = "百伦合并状态")
    private String bailunMergeStatus;

    @ApiModelProperty(value = "百伦拦截状态")
    private String bailunInterceptionStatus;

    @ApiModelProperty(value = "百伦发货状态")
    private String bailunShippingStatus;

    @ApiModelProperty(value = "百伦退款状态")
    private String bailunRefundStatus;

    @ApiModelProperty(value = "销售订单汇率-转人民币")
    private BigDecimal sellerOrderExchangeRate;

    @ApiModelProperty(value = "销售其他汇率-转人民币")
    private BigDecimal sellerOtherExchangeRate;

    @ApiModelProperty(value = "财务订单汇率-转人民币")
    private BigDecimal financeOrderExchangeRate;

    @ApiModelProperty(value = "财务其他汇率-转人民币")
    private BigDecimal financeOtherExchangeRate;

    @ApiModelProperty(value = "人民币转美元汇率")
    private BigDecimal cnyToUsdExchangeRate;

    @ApiModelProperty(value = "Order币种转美元汇率")
    private BigDecimal orderToUsdExchangeRate;

    @ApiModelProperty(value = "Other币种转美元汇率")
    private BigDecimal otherToUsdExchangeRate;

    @ApiModelProperty(value = "订单币种")
    private String orderCurrency;

    @ApiModelProperty(value = "其他币种e.g.平台费")
    private String otherCurrency;

    @ApiModelProperty(value = "销售额-原币种")
    private BigDecimal amountSales;

    @ApiModelProperty(value = "收入总金额-原币种")
    private BigDecimal amountTotal;

    @ApiModelProperty(value = "运费收入金额-原币种")
    private BigDecimal amountShipping;

    @ApiModelProperty(value = "产品金额-原币种")
    private BigDecimal amountProduct;

    @ApiModelProperty(value = "税费收入金额-原币种")
    private BigDecimal amountTax;

    @ApiModelProperty(value = "调整金额-原币种")
    private BigDecimal amountAdjustment;

    @ApiModelProperty(value = "礼品包装金额-原币种")
    private BigDecimal amountGiftWrap;

    @ApiModelProperty(value = "退款金额-原币种; 退款率 =退款金额/总销售额")
    private BigDecimal amountRefund;

    @ApiModelProperty(value = "预付款-收钱没发货-人民币")
    private BigDecimal amountPrepaid;

    @ApiModelProperty(value = "总支出费用-人民币")
    private BigDecimal costTotal;

    @ApiModelProperty(value = "促销费用-原币种")
    private BigDecimal costPromotion;

    @ApiModelProperty(value = "平台费用-Ebay的汇率为other汇率，其他平台为原币")
    private BigDecimal costPlatformFee;

    @ApiModelProperty(value = "产品成本费用-人民币")
    private BigDecimal costProduct;

    @ApiModelProperty(value = "发货支出费用-人民币-已废弃")
    private BigDecimal costShipping;

    @ApiModelProperty(value = "包装费用-人民币-已废弃")
    private BigDecimal costPackage;

    @ApiModelProperty(value = "fba费用")
    private BigDecimal costFbaFee;

    @ApiModelProperty(value = "paypal费用-原币种")
    private BigDecimal costPaypalFee;

    @ApiModelProperty(value = "退款佣金费用")
    private BigDecimal costRefundCommisson;

    @ApiModelProperty(value = "处理费-百伦收取-人民币")
    private BigDecimal costHandleBailun;

    @ApiModelProperty(value = "第三方平台操作费-人民币")
    private BigDecimal costHandlePlatform;

    @ApiModelProperty(value = "尾程费-人民币-真实的费用")
    private BigDecimal costTail;

    @ApiModelProperty(value = "头程费-人民币")
    private BigDecimal costFirst;

    @ApiModelProperty(value = "物流费-根据LMS线路算出来的(尾程费)")
    private BigDecimal costLogistics;

    @ApiModelProperty(value = "人民币利润=总收入-总支出")
    private BigDecimal profitTotal;

    @ApiModelProperty(value = "利润率")
    private BigDecimal profitRate;

    @ApiModelProperty(value = "收货国家")
    private String receiptCountry;

    @ApiModelProperty(value = "收货城市")
    private String receiptCity;

    @ApiModelProperty(value = "收货州或区域")
    private String receiptArea;

    @ApiModelProperty(value = "收货街道")
    private String receiptAddress;

    @ApiModelProperty(value = "收货门牌")
    private String receiptAddress2;

    @ApiModelProperty(value = "收货邮编")
    private String receiptPostalCode;

    @ApiModelProperty(value = "收货人")
    private String receiver;

    @ApiModelProperty(value = "收货电话")
    private String receiverPhone;

    @ApiModelProperty(value = "买家账号Id")
    private String buyerId;

    @ApiModelProperty(value = "买家账号")
    private String buyerName;

    @ApiModelProperty(value = "买家账号")
    private String buyerEmail;

    @ApiModelProperty(value = "是否FBA费用异常")
    private Boolean hasFbaException;

    @ApiModelProperty(value = "是否平台费用异常")
    private Boolean hasPlatformException;

    @ApiModelProperty(value = "是否被平台取消")
    private Boolean hasCancle;

    @ApiModelProperty(value = "区域Id")
    private Integer areaId;

    @ApiModelProperty(value = "数据中心创建时间")
    private LocalDateTime gmtCreate;

    @ApiModelProperty(value = "数据中心更新时间")
    private LocalDateTime gmtModified;

    @ApiModelProperty(value = "订单里百伦SKU总数量")
    private Integer quantityBailunSku;

    @ApiModelProperty(value = "以SKU为准-配货线路-仓库")
    private String logisticsWarehouseCode;

    @ApiModelProperty(value = "以SKU为准-配货线路-仓库")
    private String logisticsWarehouseName;

    @ApiModelProperty(value = "以SKU为准-配货线路-方式")
    private String logisticsMethodCode;

    @ApiModelProperty(value = "以SKU为准-配货线路-方式")
    private String logisticsMethodName;

    @ApiModelProperty(value = "百伦配货状态")
    private String bailunPickingStatus;

    @ApiModelProperty(value = "订单指定的物流方式")
    private String bailunRequireLogistics;

    @ApiModelProperty(value = "是否刷单订单")
    private Boolean hasScalp;

    @ApiModelProperty(value = "是否顾客留言")
    private Boolean hasBuyerRemark;

    @ApiModelProperty(value = "是否产品备注")
    private Boolean hasPlatskuRemark;

    @ApiModelProperty(value = "是否内购订单")
    private Boolean hasInnersale;

    @ApiModelProperty(value = "公司Id, 默认0是无意义的")
    private Integer companyId;

    @ApiModelProperty(value = "OMS算出的利润")
    private BigDecimal profitOms;

    @ApiModelProperty(value = "退款对象")
    private String refundObj;

    @ApiModelProperty(value = "退款类型")
    private String refundType;

    @ApiModelProperty(value = "退款ReferenceID")
    private String refundReferenceId;

    @ApiModelProperty(value = "是否FBA-S0前缀单")
    private Boolean hasFbaS;

    @ApiModelProperty(value = "普货货值")
    private BigDecimal amountGeneralCargo;

    @ApiModelProperty(value = "合并单号")
    private String aftermergedBailunOrderNo;

    @ApiModelProperty(value = "是否有fba费")
    private Boolean hasFbaFee;

    @ApiModelProperty(value = "是否手工单")
    private Boolean hasTransferOrder;

    @ApiModelProperty(value = "数据源报警code")
    private String warningType;

    @ApiModelProperty(value = "数据源报警")
    private String warningTypeName;

    @ApiModelProperty(value = "退款数据json")
    private String refundJson;

    private BigDecimal totalFee;

    private BigDecimal shipping;

    private BigDecimal opf;

    private BigDecimal fsc;

    private BigDecimal dt;

    private BigDecimal rsf;

    private BigDecimal otf;

    private BigDecimal whf;


}
