package com.bailuntec.domain;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 
 * </p>
 *
 * @author robbendev
 * @since 2020-10-08
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="DcBaseFinanceHandlefee对象", description="")
public class DcBaseFinanceHandlefee implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "财务id")
    private Integer cwId;

    @ApiModelProperty(value = "交易流水")
    private String tradCode;

    @ApiModelProperty(value = "付款主体值")
    private Integer subjectValueFrom;

    @ApiModelProperty(value = "付款主体名称")
    private String subjectNameFrom;

    @ApiModelProperty(value = "银行帐号ID")
    @TableField("pay_account_iDFrom")
    private Integer payAccountIdfrom;

    @ApiModelProperty(value = "银行名称")
    private String bankNameFrom;

    @ApiModelProperty(value = "银行帐号")
    private String bankCardFrom;

    @ApiModelProperty(value = "持卡人")
    private String bankCardUserFrom;

    @ApiModelProperty(value = "供应商ID")
    @TableField("supplier_iDFrom")
    private Integer supplierIdfrom;

    @ApiModelProperty(value = "供应商名称")
    private String supplierNameFrom;

    @ApiModelProperty(value = "交易类型 1付款 2 收款")
    private Integer tradeType;

    @ApiModelProperty(value = "交易-付款主体值")
    private String subjectValueTo;

    @ApiModelProperty(value = "交易-付款主体名称")
    private String subjectNameTo;

    @ApiModelProperty(value = "交易-银行账户ID")
    @TableField("pay_account_iDTo")
    private Integer payAccountIdto;

    @ApiModelProperty(value = "交易-银行名称")
    private String bankNameTo;

    @ApiModelProperty(value = "交易-银行帐号")
    private String bankCardTo;

    @ApiModelProperty(value = "交易-持卡人")
    private String bankCardUserTo;

    @ApiModelProperty(value = "交易-供应商ID")
    @TableField("supplier_iDTo")
    private Integer supplierIdto;

    @ApiModelProperty(value = "交易-供应商名称")
    private String supplierNameTo;

    @ApiModelProperty(value = "交易-币种名称")
    private String unitNameto;

    @ApiModelProperty(value = "交易-币种编号")
    private String unitCodeto;

    @ApiModelProperty(value = "交易-币种汇率")
    private BigDecimal rate;

    @ApiModelProperty(value = "交易-交易金额")
    private BigDecimal payMoneyto;

    @ApiModelProperty(value = "币种名称")
    private String unitName;

    @ApiModelProperty(value = "币种编号")
    private String unitCode;

    @ApiModelProperty(value = "交易金额")
    private BigDecimal payMoney;

    @ApiModelProperty(value = "交易金额人民币")
    @TableField("pay_money_rMB")
    private BigDecimal payMoneyRmb;

    @ApiModelProperty(value = "交易前的余额")
    private BigDecimal oldMoney;

    @ApiModelProperty(value = "交易后的余额")
    private BigDecimal newMoney;

    @ApiModelProperty(value = "前一天的余额")
    private BigDecimal beforeDayMoney;

    @ApiModelProperty(value = "备注/摘要")
    private String remark;

    @ApiModelProperty(value = "附件")
    private String annex;

    @ApiModelProperty(value = "删除状态 0 正常 1作废")
    private Integer hasDelete;

    @ApiModelProperty(value = "作废备注")
    private String deleteRemark;

    @ApiModelProperty(value = "创建人")
    @TableField("create_user_iD")
    private Integer createUserId;

    @ApiModelProperty(value = "创建人名称")
    private String createUserName;

    @ApiModelProperty(value = "创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "关联转账记录ID")
    @TableField("fetter_trade_iD")
    private Integer fetterTradeId;

    @ApiModelProperty(value = "关联转账记录流水号")
    private String fetterTradeCode;

    @ApiModelProperty(value = "来源 0账户互转 1财务出纳 2提现收入 3币种金额互转 4调账 5供应商退回 6手续费 7借贷")
    private String source;

    @ApiModelProperty(value = "交易类别 0常规转账 1银行手续费")
    private String tradeCategory;

    @ApiModelProperty(value = "出纳申请单ID")
    @TableField("payment_iD")
    private Integer paymentId;

    @ApiModelProperty(value = "采购单分类")
    @TableField("pur_category_iD")
    private Integer purCategoryId;

    @ApiModelProperty(value = "采购单分类名称")
    private String purCategoryName;

    @ApiModelProperty(value = "出纳申请单号，在采购系统确认收款时记录")
    private String applyCode;

    @ApiModelProperty(value = "原始汇率")
    private BigDecimal originalRate;

    @ApiModelProperty(value = "来源系统")
    private String cashierSourceName;

    @ApiModelProperty(value = "采购单号")
    private String cashierDetailName;

    @ApiModelProperty(value = "出纳单号")
    private String cashierCode;

    @ApiModelProperty(value = "出纳单交易类型 -1转账支出 -2替人代付 2找人代付 3提现收入 -4还款支出 4借款收入")
    private String casherTransactionType;

    @ApiModelProperty(value = "出纳单ID")
    private Integer cashierId;

    @ApiModelProperty(value = "出纳单其他订单流水号")
    private String cashierOtherOrderCode;


}
