package com.bailuntec.job;


import com.bailuntec.job.service.MidCalculateTransitService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

@Slf4j
@Component
public class MidCalculateTransitJob {

    @Resource
    MidCalculateTransitService midCalculateTransitService;

    @Scheduled(cron = "0 0/10 * * * ?")
    public void midCalculateNoShippedQuantity() {
        try {
            log.info("每10分钟同步bailunSku+warehouseCode待发货数量 开始");
            midCalculateTransitService.midCalculateNoShippedQuantity();
            log.info("每10分钟同步bailunSku+warehouseCode待发货数量 结束");
        } catch (Exception ex) {
            log.error("每10分钟同步bailunSku+warehouseCode待发货数量 异常:", ex);
        }
    }


    @Scheduled(cron = "0 0/10 * * * ?")
    public void midCalculateOutStockQuantity() {
        try {
            log.info("每10分钟同步bailunSku+warehouseCode缺货数量 开始");
            midCalculateTransitService.midCalculateOutStockQuantity();
            log.info("每10分钟同步bailunSku+warehouseCode缺货数量 结束");
        } catch (Exception ex) {
            log.error("每10分钟同步bailunSku+warehouseCode缺货数量 异常:", ex);
        }
    }

    @Scheduled(cron = "0 0/10 * * * ?")
    public void midCalculateTransferTransitQuantity() {
        try {
            log.info("每分钟同步bailunSku-warehouseCode调拨在途数量 开始");
            midCalculateTransitService.midCalculateTransferTransitQuantity();
            log.info("每分钟同步bailunSku-warehouseCode调拨在途数量 结束");
        } catch (Exception ex) {
            log.error("每分钟同步bailunSku-warehouseCode调拨在途数量 异常:", ex);
        }
    }

    @Scheduled(cron = "0 0/10 * * * ?")
    public void midCalculatePurchaseTransitQuantity() {
        try {
            log.info("每分钟同步bailunSku-warehouseCode采购在途数量 开始");
            midCalculateTransitService.midCalculatePurchaseTransitQuantity();
            log.info("每分钟同步bailunSku-warehouseCode采购在途数量 结束");
        } catch (Exception ex) {
            log.error("每分钟同步bailunSku-warehouseCode采购在途数量 异常:", ex);
        }
    }


}
