package com.bailuntec.job.service;

import com.bailuntec.api.bailuntec.purchase.PurchaseApi;
import com.bailuntec.api.bailuntec.purchase.resp.PurchaseDetailDto;
import com.bailuntec.application.IDcBasePurchaseDetailsService;
import com.bailuntec.common.BeanUtils;
import com.bailuntec.common.ListUtil;
import com.bailuntec.domain.DcBasePurchaseDetails;
import com.bailuntec.domain.DcJobConfig;
import com.bailuntec.infrastructure.mapper.DcJobConfigMapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/10/7 11:38 上午
 */
@Slf4j
@Service
public class SyncPurchaseDetailService {


    private final static String basePurchaseDetails = "base-purchase-details";

    @Resource
    DcJobConfigMapper dcJobConfigMapper;
    @Resource
    PurchaseApi purchaseApi;
    @Resource
    IDcBasePurchaseDetailsService dcBasePurchaseDetailsService;

    @Transactional
    public void syncPurchaseDetails() {
        DcJobConfig dcJobConfig = dcJobConfigMapper.selectByName(basePurchaseDetails);
        String startTime = dcJobConfig.getStartTimeStr();
        String endTime = dcJobConfig.getEndTimeStr();
        Integer pageNum = 1;
        Integer pageSize = 100;

        for (; ; ) {
            List<PurchaseDetailDto> purchaseDetailDtoList = purchaseApi.GetPagePurchaseSkuInfo(startTime, endTime, pageSize, pageNum).getData();

            if (ListUtil.isEmpty(purchaseDetailDtoList)) {
                break;
            }
            purchaseDetailDtoList.forEach(purchaseDetailDto -> {
                LambdaQueryWrapper<DcBasePurchaseDetails> wrapper = new LambdaQueryWrapper<DcBasePurchaseDetails>()
                        .eq(DcBasePurchaseDetails::getBailunSku, purchaseDetailDto.getBailunSku())
                        .eq(DcBasePurchaseDetails::getPurchaseId, purchaseDetailDto.getPurchaseId());
                DcBasePurchaseDetails dcBasePurchaseDetails = dcBasePurchaseDetailsService.getOne(wrapper);
                if (dcBasePurchaseDetails == null) {
                    dcBasePurchaseDetails = new DcBasePurchaseDetails();
                }
                BeanUtils.copyProperties(purchaseDetailDto, dcBasePurchaseDetails, "id");
                dcBasePurchaseDetails.setCreateTime(LocalDateTime.parse(purchaseDetailDto.getCreateTimed(), DateTimeFormatter.ofPattern("yyyy/M/d H:m:s")));
                dcBasePurchaseDetails.setUpdateTime(LocalDateTime.parse(purchaseDetailDto.getUpdateTimed(), DateTimeFormatter.ofPattern("yyyy/M/d H:m:s")));
                dcBasePurchaseDetails.setGmtModified(LocalDateTime.now());

                dcBasePurchaseDetailsService.saveOrUpdate(dcBasePurchaseDetails);

            });
            pageNum++;

        }

        dcJobConfigMapper.updateById(dcJobConfig.refresh());
    }
}
