package com.bailuntec.infrastructure.mapper;

import com.bailuntec.domain.DcMidTransit;
import com.bailuntec.infrastructure.common.BaseJobSqlParam;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <p>
 * 在途中间表 Mapper 接口
 * </p>
 *
 * @author robbendev
 * @since 2020-08-19
 */
public interface DcMidTransitMapper extends BaseMapper<DcMidTransit> {

    //清空缺货数
    void clearOutStockQuantity();

    //根据bailunSku warehouse查询在途中间数据
    DcMidTransit selectByUnionKey(@Param("bailunSku") String bailunSku, @Param("warehouseCode") String warehouseCode);

    //分页查询缺货数量
    //todo slow sql 临时表1w 暂时不优化
    List<DcMidTransit> selectOutStockQuantity(BaseJobSqlParam jobParam);

    //清空采购在途数
    void clearPurchaseTransitQuantity();

    //分页查询采购在途数量
    List<DcMidTransit> selectPurchaseTransitQuantity(BaseJobSqlParam jobParam);

    //清空调拨在途数量
    void clearTransferTransitQuantity();

    //分页查询调拨在途数量
    //todo slow sql
    List<DcMidTransit> selectTransferTransitQuantity(BaseJobSqlParam jobParam);

    //清空未发货数量
    void clearNoShippedQuantity();

    //分页查询未发货数量
    List<DcMidTransit> selectNoShippedQuantity(BaseJobSqlParam jobParam);
}
