package com.bailuntec.infrastructure.mapper;

import com.bailuntec.domain.DcBalanceSheet;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * <p>
 * 资产负债表,RMB Mapper 接口
 * </p>
 *
 * @author robbendev
 * @since 2020-11-03
 */
public interface DcBalanceSheetMapper extends BaseMapper<DcBalanceSheet> {

    @Insert("insert into dc_balance_sheet(company_value,company_name,statistical_time) values (#{companyValue},#{companyName},#{lastDay})")
    Integer insertBalanceSheet(@Param("companyValue") Integer companyValue, @Param("companyName") String companyName, @Param("lastDay") LocalDate lastDay);

    @Select("select * from dc_balance_sheet where statistical_time = #{lastDay} and company_value = #{companyValue} and company_name = #{companyName} limit 1")
    DcBalanceSheet getDcBalanceSheetInit(@Param("companyValue") Integer companyValue, @Param("companyName") String companyName, @Param("lastDay") LocalDate lastDay);

    @Select("select platform_balance from dc_balance_sheet where statistical_time = #{lastDay}")
    BigDecimal getPlatformBalanceUpdate(LocalDate lastDay);

    @Select("select ifnull(sum((amount - ifnull(had_pay, 0) + ifnull(compensate, 0)) * to_rmb_rate),0) from dc_daily_fee where recoed_time = #{lastDay} and company_name not in ('香港四千里数据科技有限公司','YOUNGTOP INTERNATIONAL LIMITED','深圳市四千里数据科技有限公司','4Kmiles tec Limited','广州四千里数据科技有限公司','（英国）4kmiles technologies ltd')")
    BigDecimal getAmountBorrowed(LocalDate lastDay);

    @Select("select ifnull(sum(other_accounts_receivable_import),0) from dc_balance_sheet where statistical_time = #{lastDay}")
    BigDecimal getOtherAccountsReceivableImport(LocalDate lastDay);

    @Select("select ifnull(sum(fixed_assets_import),0) from dc_balance_sheet where statistical_time = #{lastDay}")
    BigDecimal getFixedAssetsImport(LocalDate lastDay);

    @Select("select finished_accounts_payable from dc_balance_sheet where statistical_time <= #{lastDay} and finished_accounts_payable > 0 order by finished_accounts_payable desc limit 1 ")
    BigDecimal getFinashedAccountSumByOld(@Param("lastDay") LocalDate lastDay);

    @Select({"select logistics_accounts_payable from dc_balance_sheet where statistical_time = #{date}"})
    BigDecimal getLogisticsAccountsPayableInit(@Param("date") LocalDate date);

    @Select({"select finished_accounts_payable from dc_balance_sheet where statistical_time = #{date}"})
    BigDecimal getLogisticsAccountsPayableSum(@Param("date") LocalDate date);

    @Select("select finished_accounts_payable from dc_balance_sheet where statistical_time <= #{date} and finished_accounts_payable > 0 order by finished_accounts_payable desc limit 1 ")
    BigDecimal getLogisticsAccountsPayableSumByOld(@Param("date") LocalDate date);

    @Select("select accounts_receivable_import from dc_balance_sheet where statistical_time = #{lastDay} ")
    BigDecimal getAccountsReceivableImport(@Param("lastDay") LocalDate lastDay);

    @Select("select accounts_receivable_update from dc_balance_sheet where statistical_time = #{lastDay} ")
    BigDecimal getAccountsReceivableUpdate(@Param("lastDay") LocalDate lastDay);

    int updateByCompanyAndDaySelective(DcBalanceSheet dcBalanceSheet);
}
