package com.bailuntec.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * @Author: li.yanlin
 * @Description：
 * @Date: Created in
 * @Modified by:
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="DcLogisticsSupplierTransaction对象", description="物流供应商往来数据表")
public class DcLogisticsSupplierTransaction implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "供应商ID")
    private Integer supplierId;

    @ApiModelProperty(value = "供应商名称")
    private String supplierName;

    @ApiModelProperty(value = "公司主体value")
    private Integer payCompanyValue;

    @ApiModelProperty(value = "公司主体名称")
    private String payCompanyName;

    @ApiModelProperty(value = "期初金额")
    private BigDecimal startAmount;

    @ApiModelProperty(value = "期末金额")
    private BigDecimal endAmount;

    @ApiModelProperty(value = "")
    private BigDecimal borrowAmount;

    @ApiModelProperty(value = "期末金额")
    private BigDecimal loanAmount;

    @ApiModelProperty(value = "供应商类型")
    private String type;

    @ApiModelProperty(value = "统计日期")
    private LocalDate day;
}
