package com.bailuntec.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020-08-19
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "DcBaseFinanceFee对象", description = "")
public class DcBaseFinanceFee implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "费用单表 id")
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "计划编号")
    private String costPlanNo;

    @ApiModelProperty(value = "费用单编号")
    private String costNo;

    @ApiModelProperty(value = "付款理由")
    private String costReason;

    @ApiModelProperty(value = "费用类 1付款  2收款  3借支/借还")
    private Integer costForm;

    @ApiModelProperty(value = "主体编号")
    private String companyNo;

    @ApiModelProperty(value = "主体名称")
    private String companyName;

    @ApiModelProperty(value = "会计科目")
    private String accountingSubjectName;

    @ApiModelProperty(value = "大类编号")
    private String typeNo;

    @ApiModelProperty(value = "大类标题")
    private String typeName;

    @ApiModelProperty(value = "小类编号")
    private String kindNo;

    @ApiModelProperty(value = "小类标题")
    private String kindName;

    @ApiModelProperty(value = "创建人 id")
    private Integer createUserid;

    @ApiModelProperty(value = "创建人编号")
    private String createUsercode;

    @ApiModelProperty(value = "创建人名称")
    private String createUsername;

    @ApiModelProperty(value = "费用单备注")
    private String costRemark;

    @ApiModelProperty(value = "创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "费用单状态 0 待提交 1待审核 2待出纳付款 3被驳回 4已支付 5已作废")
    private Integer costStatus;

    @ApiModelProperty(value = "文件地址")
    private String filePath;

    @ApiModelProperty(value = "补充材料地址")
    private String morFilePath;

    @ApiModelProperty(value = "费用总金额")
    private BigDecimal amount;

    @ApiModelProperty(value = "收款/付款银行（或支付宝）")
    private String bankName;

    @ApiModelProperty(value = "收款/付款账号")
    private String bankCard;

    @ApiModelProperty(value = "收款/付款人（创建人）")
    private String bankCardUser;

    @ApiModelProperty(value = "收款/付款单位")
    private String bankCompany;

    @ApiModelProperty(value = "补充信息")
    private String morRemark;

    @ApiModelProperty(value = "关联子单")
    private String sonCostNo;

    @ApiModelProperty(value = "关联父单")
    private String supCostNo;

    @ApiModelProperty(value = "1 借支 2 借还")
    private Integer isLend;

    @ApiModelProperty(value = "借支单已还金额")
    private BigDecimal hadPay;

    @ApiModelProperty(value = "借支单状态 1 未还 2 部分还款  3 待补差额  4 结清")
    private Integer lendStatus;

    @ApiModelProperty(value = "借支单补偿金额")
    private BigDecimal compensate;

    @ApiModelProperty(value = "借还单冲销金额")
    private BigDecimal counteract;

    @ApiModelProperty(value = "借还单余额")
    private BigDecimal lendBalance;

    @ApiModelProperty(value = "驳回理由")
    private String rejectReason;

    @ApiModelProperty(value = "币种")
    private String dic;

    @ApiModelProperty(value = "借还单冲销金额 ( 支付币种 )")
    private BigDecimal payCounteract;

    @ApiModelProperty(value = "借还单余额 （ 支付币种 ）")
    private BigDecimal payLendBalance;

    @ApiModelProperty(value = "计划金额 （ 支付币种 ）")
    private BigDecimal payPlanAmount;

    @ApiModelProperty(value = "支付币种")
    private String payDic;

    @ApiModelProperty(value = "汇率")
    private BigDecimal payCur;

    @ApiModelProperty(value = "0 不抵扣个税  1 抵扣个税")
    private Integer isTax;

    @ApiModelProperty(value = "出纳系统 detailKey")
    private String detailKey;

    @ApiModelProperty(value = "支付者用户id")
    private Integer payUserId;

    @ApiModelProperty(value = "支付时间")
    private LocalDateTime payTime;

    @ApiModelProperty(value = "人民币总金额")
    private BigDecimal amountRmb;

    @ApiModelProperty(value = "xx货币转人民币汇率")
    private BigDecimal toRmbRate;

    private Integer subLogisticsSupplierId;

    private Integer logisticsSupplierId;

    @ApiModelProperty(value = "科目编号")
    private String subjectCode;

    @ApiModelProperty(value = "公司主体value")
    private Integer companyValue;

    @ApiModelProperty(value = "财务审核时间")
    private LocalDateTime auditTime;

    @ApiModelProperty(value = "最后更新时间")
    private LocalDateTime lastModifyDate;

    @ApiModelProperty(value = "数据中心创建时间")
    private LocalDateTime bjCreate;

    private LocalDateTime bjModified;

    @ApiModelProperty(value = "项目")
    private String projectType;

    @ApiModelProperty(value = "客户编号")
    private String customerNum;

    @ApiModelProperty("是否管理成本")
    private Boolean isManageCost;

    @ApiModelProperty("部门名称")
    private String departmentName;
}
