package com.bailuntec.job.service;

import com.bailuntec.application.IDcMidTransitService;
import com.bailuntec.common.ListUtil;
import com.bailuntec.domain.DcJobConfig;
import com.bailuntec.domain.DcMidTransit;
import com.bailuntec.infrastructure.common.BaseJobSqlParam;
import com.bailuntec.infrastructure.mapper.DcJobConfigMapper;
import com.bailuntec.infrastructure.mapper.DcMidTransitMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/10/7 11:38 上午
 */
@Slf4j
@Service
public class MidCalculateTransitService {

    @Resource
    DcMidTransitMapper dcMidTransitMapper;
    @Resource
    DcJobConfigMapper dcJobConfigMapper;
    @Resource
    IDcMidTransitService dcMidTransitService;

    private final static String midCalculateOutStockQuantity = "mid-calculate-out-stock-quantity";
    private final static String midCalculatePurchaseTransitQuantity = "mid-calculate-purchase-transit-quantity";
    private final static String midCalculateTransferTransitQuantity = "mid-calculate-transfer-transit-quantity";
    private final static String midCalculateNoShippedQuantity = "mid-calculate-no-shipped-quantity";


    @Transactional
    public void midCalculateOutStockQuantity() {
        DcJobConfig dcJobConfig = dcJobConfigMapper.selectByName(midCalculateOutStockQuantity);
        int pageNum = dcJobConfig.getPageNum();
        dcMidTransitMapper.clearOutStockQuantity();
        for (; ; ) {
            List<DcMidTransit> dcMidTransitList = dcMidTransitMapper.selectOutStockQuantity(BaseJobSqlParam.newInstance(dcJobConfig));
            if (ListUtil.isEmpty(dcMidTransitList)) {
                break;
            }
            dcMidTransitList.forEach(dcMidTransit -> dcMidTransit.setGmtOutStockModified(LocalDateTime.now()));
            dcMidTransitService.saveOrUpdateBatch(dcMidTransitList);
            pageNum++;
            dcJobConfig.setPageNum(pageNum);
            dcJobConfigMapper.updateById(dcJobConfig);
        }
        dcJobConfigMapper.updateById(dcJobConfig.refresh());
    }

    @Transactional
    public void midCalculatePurchaseTransitQuantity() {
        DcJobConfig dcJobConfig = dcJobConfigMapper.selectByName(midCalculatePurchaseTransitQuantity);
        int pageNum = dcJobConfig.getPageNum();
        dcMidTransitMapper.clearPurchaseTransitQuantity();
        for (; ; ) {
            //分页查询采购
            List<DcMidTransit> dcMidTransitList = dcMidTransitMapper.selectPurchaseTransitQuantity(BaseJobSqlParam.newInstance(dcJobConfig));
            if (ListUtil.isEmpty(dcMidTransitList)) {
                break;
            }

            dcMidTransitList.forEach(dcMidTransit -> dcMidTransit.setGmtPurchaseModified(LocalDateTime.now()));
            dcMidTransitService.saveOrUpdateBatch(dcMidTransitList);

            pageNum++;
            dcJobConfig.setPageNum(pageNum);
            dcJobConfigMapper.updateById(dcJobConfig);
        }
        dcJobConfigMapper.updateById(dcJobConfig.refresh());
    }


    @Transactional
    public void midCalculateTransferTransitQuantity() {
        DcJobConfig dcJobConfig = dcJobConfigMapper.selectByName(midCalculateTransferTransitQuantity);
        int pageNum = dcJobConfig.getPageNum();
        dcMidTransitMapper.clearTransferTransitQuantity();
        for (; ; ) {
            List<DcMidTransit> dcMidTransitList = dcMidTransitMapper.selectTransferTransitQuantity(BaseJobSqlParam.newInstance(dcJobConfig));
            if (ListUtil.isEmpty(dcMidTransitList)) {
                break;
            }
            dcMidTransitList.forEach(dcMidTransit -> dcMidTransit.setGmtTransferModified(LocalDateTime.now()));
            dcMidTransitService.saveOrUpdateBatch(dcMidTransitList);

            pageNum++;
            dcJobConfig.setPageNum(pageNum);
            dcJobConfigMapper.updateById(dcJobConfig);
        }
        dcJobConfigMapper.updateById(dcJobConfig.refresh());
    }

    @Transactional
    public void midCalculateNoShippedQuantity() {
        DcJobConfig dcJobConfig = dcJobConfigMapper.selectByName(midCalculateNoShippedQuantity);
        int pageNum = dcJobConfig.getPageNum();
        dcMidTransitMapper.clearNoShippedQuantity();
        for (; ; ) {
            List<DcMidTransit> dcMidTransitList = dcMidTransitMapper.selectNoShippedQuantity(BaseJobSqlParam.newInstance(dcJobConfig));
            if (ListUtil.isEmpty(dcMidTransitList)) {
                break;
            }
            dcMidTransitList.forEach(dcMidTransit -> dcMidTransit.setGmtUnshippedModified(LocalDateTime.now()));
            dcMidTransitService.saveOrUpdateBatch(dcMidTransitList);

            pageNum++;
            dcJobConfig.setPageNum(pageNum);
            dcJobConfigMapper.updateById(dcJobConfig);
        }
        dcJobConfigMapper.updateById(dcJobConfig.refresh());
    }
}
