package com.bailuntec.job.service;

import com.bailuntec.domain.DcJobConfig;
import com.bailuntec.domain.JobAmazonAdLog;
import com.bailuntec.infrastructure.mapper.DcJobConfigMapper;
import com.bailuntec.infrastructure.mapper.JobAmazonAdLogMapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import feign.FeignException;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/10/7 11:38 上午
 */
@Slf4j
@Service
public class EbayService {

    private final static String baseSyncFinanceEbayAd = "base-sync-finance-ebay-ad";

    @Resource
    DcJobConfigMapper dcJobConfigMapper;
    @Resource
    JobAmazonAdLogMapper jobAmazonAdLogMapper;

    public void sync() {
        DcJobConfig dcJobConfig = dcJobConfigMapper.selectByName(baseSyncFinanceEbayAd);
        List<JobAmazonAdLog> jobAmazonAdLogList = jobAmazonAdLogMapper.selectList(new LambdaQueryWrapper<JobAmazonAdLog>()
                .eq(JobAmazonAdLog::getStatus, false));

        dcJobConfigMapper.updateById(dcJobConfig.refresh());
    }
}
