package com.bailuntec.job;


import com.bailuntec.job.service.EbayService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

@Slf4j
@Component
public class EbayJob {

    @Resource
    EbayService ebayService;

    @Scheduled(cron = "0 0/1 * * * ?")
    public void baseSyncFinanceFee() {
        try {
            log.info("每分钟同步费用单 开始");
            ebayService.sync();
            log.info("每分钟同步费用单 结束");
        } catch (Exception ex) {
            log.error("每分钟同步费用单 异常:", ex);
        }
    }


}
