package com.bailuntec.job;


import com.bailuntec.job.service.CompanyService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.text.ParseException;

@Slf4j
@Component
public class SyncCompanyJob {

    @Resource
    CompanyService companyService;

    @Scheduled(cron = "0 0/1 * * * ?")
    public void baseSyncFinanceFee() {
        try {
            log.info("每分钟同步百伦公司帐号 开始");
            companyService.syncCompanyAccount();
            log.info("每分钟同步百伦公司帐号 结束");
        } catch (Exception ex) {
            log.error("每分钟同步百伦公司帐号 异常:", ex);
        }
    }




}
