package com.bailuntec.domain;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 下单记录表
 * </p>
 *
 * @author robbendev
 * @since 2020-08-19
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="DcAutoOrder对象", description="下单记录表")
public class DcAutoOrder implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "sku编码")
    private String bailunSku;

    @ApiModelProperty(value = "到货仓库编码")
    private String warehouseCode;

    @ApiModelProperty(value = "到货仓库名称")
    private String warehouseName;

    @ApiModelProperty(value = "调拨仓库编码")
    private String warehouseCodeTo;

    @ApiModelProperty(value = "调拨仓库名称")
    private String warehouseNameTo;

    @ApiModelProperty(value = "下单类型，1：采购单")
    private Integer type;

    @ApiModelProperty(value = "下单数量")
    private Integer buycount;

    @ApiModelProperty(value = "下单价格")
    private BigDecimal price;

    @ApiModelProperty(value = "供应商id")
    private Integer supplierid;

    @ApiModelProperty(value = "供应商名称")
    private String suppliername;

    @ApiModelProperty(value = "预计到货时间")
    private LocalDateTime arrivaltime;

    @ApiModelProperty(value = "采购员")
    private String buyer;

    @ApiModelProperty(value = "创建时间")
    private LocalDateTime createtime;

    @ApiModelProperty(value = "创建人名称")
    private String createusername;

    @ApiModelProperty(value = "备注")
    private String note;

    @ApiModelProperty(value = "采购单id")
    private Integer buyid;

    @ApiModelProperty(value = "采购单号")
    private String buyno;

    @ApiModelProperty(value = "状态：-1：作废，0：未下单，1：已提交，2：下单成功")
    private Integer status;


}
