package com.bailuntec.task.writer;

import com.bailuntec.application.IEbayAccountReportTaskService;
import com.bailuntec.domain.EbayAccountReportTask;
import lombok.extern.slf4j.Slf4j;
import org.springframework.batch.item.ItemWriter;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2021/1/21 5:04 下午
 */
@Component
@Slf4j
public class CustomerWriter implements ItemWriter<EbayAccountReportTask> {
    @Resource
    IEbayAccountReportTaskService ebayAccountReportTaskService;

    @Override
    public void write(List<? extends EbayAccountReportTask> items) {
        log.info("批量写入EbayAccountReportTask");
        ebayAccountReportTaskService.saveBatch(items.stream().map(var -> (EbayAccountReportTask) var).collect(Collectors.toList()));

    }
}
