package com.bailuntec.task.processor;

import com.bailuntec.domain.DcBaseCompanyAccount;
import com.bailuntec.domain.DcJobConfig;
import com.bailuntec.domain.EbayAccountReportTask;
import com.bailuntec.task.config.JobProperty;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.time.LocalTime;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2021/1/21 5:01 下午
 */
@Component
public class CustomerProcessor implements ItemProcessor<DcBaseCompanyAccount, EbayAccountReportTask> {

    @Resource
    JobProperty jobProperty;


    @Override
    public EbayAccountReportTask process(@NonNull DcBaseCompanyAccount item) {
        EbayAccountReportTask ebayAccountReportTask = new EbayAccountReportTask();

        DcJobConfig dcJobConfig = jobProperty.getDcJobConfig();

        ebayAccountReportTask.setAccountId(item.getAccountId());
        ebayAccountReportTask.setStartTime(LocalDateTime.of(dcJobConfig.getStartTime().toLocalDate(), LocalTime.MIN));
        ebayAccountReportTask.setEndTime(LocalDateTime.of(dcJobConfig.getStartTime().toLocalDate(), LocalTime.MIN).plusDays(1));

        return ebayAccountReportTask;
    }
}
