package com.bailuntec.infrastructure.mapper;

import com.bailuntec.domain.DcDailyStock;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <p>
 * 实时环球库存每日信息表 Mapper 接口
 * </p>
 *
 * @author robbendev
 * @since 2020-12-09
 */
public interface DcDailyStockMapper extends BaseMapper<DcDailyStock> {


    /**
     * 查询库存
     *
     * @param pageStart pageStart
     * @param pageSize  pageSize
     * @return 库存
     */
    List<DcDailyStock> selectSnapShot(@Param("pageStart") int pageStart, @Param("pageOffset") int pageSize);

    /**
     * 清除昨天快照
     */
    void clearSnapShot();
}
