package com.bailuntec.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 百伦OMS订单-SKU维度
 * </p>
 *
 * @author robbendev
 * @since 2020-11-25
 */
@TableName("dc_base_oms_sku_30")
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "DcBaseOmsSku30对象", description = "百伦OMS订单-SKU维度")
public class DcBaseOmsSku30 extends DcBaseOmsSku implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableField(value = "sku30_modify")
    private LocalDateTime sku30Modify;

    // ------
    @TableField(exist = false)
    @ApiModelProperty(value = "订单创建时间")
    private LocalDateTime purchaseCreateTime;

    @TableField(exist = false)
    @ApiModelProperty(value = "是否有支付时间")
    private Boolean hasPaytime;

    @TableField(exist = false)
    @ApiModelProperty(value = "数据源报警code")
    private String warningType;

    @TableField(exist = false)
    @ApiModelProperty(value = "数据源报警")
    private String warningTypeName;

    @TableField(exist = false)
    @ApiModelProperty(value = "总费用")
    private BigDecimal totalFee;

    @TableField(exist = false)
    @ApiModelProperty(value = "运输费")
    private BigDecimal shipping;

    @TableField(exist = false)
    @ApiModelProperty(value = "操作费用")
    private BigDecimal opf;

    @TableField(exist = false)
    @ApiModelProperty(value = "燃油附加费")
    private BigDecimal fsc;

    @TableField(exist = false)
    @ApiModelProperty(value = "关税")
    private BigDecimal dt;

    @TableField(exist = false)
    @ApiModelProperty(value = "挂号")
    private BigDecimal rsf;

    @TableField(exist = false)
    @ApiModelProperty(value = "其他费用")
    private BigDecimal otf;

    @TableField(exist = false)
    @ApiModelProperty(value = "仓租")
    private BigDecimal whf;

    @TableField(exist = false)
    private String currencyCode;

    @TableField(exist = false)
    private BigDecimal wmsToCnyExchangeRate;

    @TableField(exist = false)
    private BigDecimal wmsToUsdExchangeRate;


}
