package com.bailuntec.domain;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 百伦头程费信息, 是WMS根据线路估算而来
 * </p>
 *
 * @author robbendev
 * @since 2020-08-19
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="DcBaseCostFirst对象", description="百伦头程费信息, 是WMS根据线路估算而来")
public class DcBaseCostFirst implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "物流单号,一个物流单可能多个调拨单")
    private String channelOrderId;

    @ApiModelProperty(value = "物流主键ID, 用来判断唯一")
    private Integer channelId;

    @ApiModelProperty(value = "箱号")
    private String boxId;

    @ApiModelProperty(value = "头程费_RMB")
    private BigDecimal costFirst;

    @ApiModelProperty(value = "报关费")
    private BigDecimal costGoodsClearance;

    @ApiModelProperty(value = "关税预付")
    private BigDecimal costDuty;

    @ApiModelProperty(value = "清关费")
    private BigDecimal costCustomsClearance;

    @ApiModelProperty(value = "原始重量邮费")
    private BigDecimal costWeight;

    @ApiModelProperty(value = "燃油附加费")
    private BigDecimal costFuel;

    @ApiModelProperty(value = "仓库编码")
    private String warehouseCode;

    @ApiModelProperty(value = "百伦SKU")
    private String bailunSku;

    @ApiModelProperty(value = "数量")
    private Integer quantity;

    @ApiModelProperty(value = "SKU重量,需要按重量计算比例")
    private BigDecimal skuWeight;

    @ApiModelProperty(value = "调拨单号")
    private String transferOrderId;

    @ApiModelProperty(value = "区域Id")
    private Integer areaId;

    @ApiModelProperty(value = "公司ID, 0和1是百伦")
    private Integer companyId;

    private LocalDateTime operationTime;

    @ApiModelProperty(value = "是否计算 0 否 1 是")
    private Boolean hasCalculation;


}
