package com.bailuntec.domain;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 销量表
 * </p>
 *
 * @author robbendev
 * @since 2020-08-19
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="DcAutoSales对象", description="销量表")
public class DcAutoSales implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键")
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "线性回归公式y = kx + b")
    private String forecastFormula;

    @ApiModelProperty(value = "百伦SKU")
    private String bailunSku;

    @ApiModelProperty(value = "SKU名称")
    private String title;

    @ApiModelProperty(value = "仓库")
    private String warehouseCode;

    @ApiModelProperty(value = "分类Id")
    private Integer categoryId;

    @ApiModelProperty(value = "过去第一日销量")
    private Integer onedaySales;

    @ApiModelProperty(value = "过去第二日销量")
    private Integer twodaySales;

    @ApiModelProperty(value = "过去第三日销量")
    private Integer threedaySales;

    @ApiModelProperty(value = "过去第四日销量")
    private Integer fourthdaySales;

    @ApiModelProperty(value = "过去第五日销量")
    private Integer fivedaySales;

    @ApiModelProperty(value = "过去第六日销量")
    private Integer sixdaySales;

    @ApiModelProperty(value = "过去第七日销量")
    private Integer sevendaySales;

    @ApiModelProperty(value = "过去第八日销量")
    private Integer eightdaySales;

    @ApiModelProperty(value = "过去第九日销量")
    private Integer ninedaySales;

    @ApiModelProperty(value = "过去第十日销量")
    private Integer tendaySales;

    @ApiModelProperty(value = "过去第十一日销量")
    private Integer elevendaySales;

    @ApiModelProperty(value = "过去第十二日销量")
    private Integer twelvedaySales;

    @ApiModelProperty(value = "过去第十三日销量")
    private Integer thridteendaySales;

    @ApiModelProperty(value = "过去第十四日销量")
    private Integer fourteendaySales;

    @ApiModelProperty(value = "过去第十五日销量")
    private Integer fifteendaySales;

    @ApiModelProperty(value = "过去第十六日销量")
    private Integer sixteendaySales;

    @ApiModelProperty(value = "过去第十七日销量")
    private Integer seventeendaySales;

    @ApiModelProperty(value = "过去第十八日销量")
    private Integer eighteendaySales;

    @ApiModelProperty(value = "过去第十九日销量")
    private Integer nineteendaySales;

    @ApiModelProperty(value = "过去第二十日销量")
    private Integer twentydaySales;

    @ApiModelProperty(value = "过去第二十一日销量")
    private Integer twentyOnedaySales;

    @ApiModelProperty(value = "过去第二十二日销量")
    private Integer twentyTwodaySales;

    @ApiModelProperty(value = "过去第二十三日销量")
    private Integer twentyThreedaySales;

    @ApiModelProperty(value = "过去第二十四日销量")
    private Integer twentyFourthdaySales;

    @ApiModelProperty(value = "过去第二十五日销量")
    private Integer twentyFivedaySales;

    @ApiModelProperty(value = "过去第二十六日销量")
    private Integer twentySixdaySales;

    @ApiModelProperty(value = "过去第二十七日销量")
    private Integer twentySevenedaySales;

    @ApiModelProperty(value = "过去第二十八日销量")
    private Integer twentyEightdaySales;

    @ApiModelProperty(value = "过去第二十九日销量")
    private Integer twentyNinedaySales;

    @ApiModelProperty(value = "过去第三十日销量")
    private Integer thirtydaySales;

    @ApiModelProperty(value = "仓库名称")
    private String warehouseName;

    @ApiModelProperty(value = "预测今日销量")
    private BigDecimal forecastTodaySales;

    @ApiModelProperty(value = "预测第一日销量")
    private BigDecimal forecastOnedaySales;

    @ApiModelProperty(value = "预测第二日销量")
    private BigDecimal forecastTwodaySales;

    @ApiModelProperty(value = "预测第三日销量")
    private BigDecimal forecastThreedaySales;

    @ApiModelProperty(value = "预测第四日销量")
    private BigDecimal forecastFourthdaySales;

    @ApiModelProperty(value = "预测第五日销量")
    private BigDecimal forecastFivedaySales;

    @ApiModelProperty(value = "预测第六日销量")
    private BigDecimal forecastSixdaySales;

    @ApiModelProperty(value = "预测第七日销量")
    private BigDecimal forecastSevendaySales;

    @ApiModelProperty(value = "预测第八日销量")
    private BigDecimal forecastEightdaySales;

    @ApiModelProperty(value = "预测第九日销量")
    private BigDecimal forecastNinedaySales;

    @ApiModelProperty(value = "预测第十日销量")
    private BigDecimal forecastTendaySales;

    @ApiModelProperty(value = "预测第十一日销量")
    private BigDecimal forecastElevendaySales;

    @ApiModelProperty(value = "预测第十二日销量")
    private BigDecimal forecastTwelvedaySales;

    @ApiModelProperty(value = "预测第十三日销量")
    private BigDecimal forecastThridteendaySales;

    @ApiModelProperty(value = "预测第十四日销量")
    private BigDecimal forecastFourteendaySales;

    @ApiModelProperty(value = "预测第十五日销量")
    private BigDecimal forecastFifteendaySales;

    @ApiModelProperty(value = "预测第十六日销量")
    private BigDecimal forecastSixteendaySales;

    @ApiModelProperty(value = "预测第十七日销量")
    private BigDecimal forecastSeventeendaySales;

    @ApiModelProperty(value = "预测第十八日销量")
    private BigDecimal forecastEighteendaySales;

    @ApiModelProperty(value = "预测第十九日销量")
    private BigDecimal forecastNineteendaySales;

    @ApiModelProperty(value = "预测第二十日销量")
    private BigDecimal forecastTwentydaySales;

    @ApiModelProperty(value = "预测第二十一日销量")
    private BigDecimal forecastTwentyOnedaySales;

    @ApiModelProperty(value = "预测第二十二日销量")
    private BigDecimal forecastTwentyTwodaySales;

    @ApiModelProperty(value = "预测第二十三日销量")
    private BigDecimal forecastTwentyThreedaySales;

    @ApiModelProperty(value = "预测第二十四日销量")
    private BigDecimal forecastTwentyFourthdaySales;

    @ApiModelProperty(value = "预测第二十五日销量")
    private BigDecimal forecastTwentyFivedaySales;

    @ApiModelProperty(value = "预测第二十六日销量")
    private BigDecimal forecastTwentySixdaySales;

    @ApiModelProperty(value = "预测第二十七日销量")
    private BigDecimal forecastTwentySevenedaySales;

    @ApiModelProperty(value = "预测第二十八日销量")
    private BigDecimal forecastTwentyEightdaySales;

    @ApiModelProperty(value = "预测第二十九日销量")
    private BigDecimal forecastTwentyNinedaySales;

    @ApiModelProperty(value = "预测第三十日销量")
    private BigDecimal forecastThirtydaySales;

    @ApiModelProperty(value = "K值")
    private BigDecimal kVariable;

    @ApiModelProperty(value = "b值")
    private BigDecimal bVariable;

    @ApiModelProperty(value = "r方")
    private BigDecimal rVariable;

    @ApiModelProperty(value = "去最大最小值的平均销量")
    private BigDecimal averageSales;

    @ApiModelProperty(value = "预测销量详细数据")
    private String details;

    @ApiModelProperty(value = "突增判断后销量详情")
    private String increaseDetails;

    @ApiModelProperty(value = "拟合a值")
    private BigDecimal fitAVariable;

    @ApiModelProperty(value = "拟合b值")
    private BigDecimal fitBVariable;

    @ApiModelProperty(value = "拟合r方")
    private BigDecimal fitRVariable;

    @ApiModelProperty(value = "拟合函数公式")
    private String fitForecastFormula;

    @ApiModelProperty(value = "历史销量详细")
    private String historySalesDetails;

    private String historyIncreaseSalesDetails;

    @ApiModelProperty(value = "创建时间")
    private LocalDateTime gmtCreate;

    @ApiModelProperty(value = "修改时间")
    private LocalDateTime gmtModified;


}
