package com.bailuntec.domain;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 银行账户余额
 * </p>
 *
 * @author robbendev
 * @since 2020-12-17
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="DcBankAccountBalanceNew对象", description="银行账户余额")
public class DcBankAccountBalanceNew implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "公司主体value")
    private Integer companyValue;

    @ApiModelProperty(value = "公司名称")
    private String companyName;

    @ApiModelProperty(value = "银行账号ID")
    private Integer payAccountId;

    @ApiModelProperty(value = "银行名称")
    private String bankName;

    @ApiModelProperty(value = "银行卡号/账号")
    private String bankCard;

    @ApiModelProperty(value = "银行持卡人")
    private String bankCardUser;

    @ApiModelProperty(value = "银行账号余额,RMB")
    private BigDecimal balanceRmb;

    @ApiModelProperty(value = "统计时间")
    private LocalDate statisticalTime;

    @ApiModelProperty(value = "取数时间")
    private LocalDateTime updateTime;

    private Integer companySystemId;

    private String companySystem;


}
