package com.bailuntec.domain;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 周转期内预测数据
 * </p>
 *
 * @author robbendev
 * @since 2020-08-19
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="DcAutoTurnover对象", description="周转期内预测数据")
public class DcAutoTurnover implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "建议单单号")
    private String purchaseAdviceId;

    @ApiModelProperty(value = "SKU")
    private String bailunSku;

    @ApiModelProperty(value = "仓库编码")
    private String warehouseCode;

    @ApiModelProperty(value = "计算的自动采购建议(算上备货销量之后的)")
    private BigDecimal quantityInitAdvise;

    @ApiModelProperty(value = "最小订单数量")
    private Integer quantityMinimumOrder;

    @ApiModelProperty(value = "跟MOQ对比后最终的的自动采购建议")
    private BigDecimal quantityFinalAdvise;

    @ApiModelProperty(value = "仓库名称")
    private String warehouseName;

    @ApiModelProperty(value = "活动促销数量")
    private Integer quantityPromotion;

    @ApiModelProperty(value = "实际库存数量")
    private Integer quantityInventory;

    @ApiModelProperty(value = "调拨在途")
    private Integer quantityTransfer;

    @ApiModelProperty(value = "采购在途")
    private Integer quantityPurchase;

    @ApiModelProperty(value = "周转天数,，国内仓：sku供应商交期+2天质检入库时间，调拨：国外仓 sku供应商交期+2天质检入库时间+7天调拨交运")
    private Integer turnoverDays;

    @ApiModelProperty(value = "安全库存")
    private BigDecimal quantitySafeInventory;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "数据中心-创建时间")
    private LocalDateTime gmtCreate;

    @ApiModelProperty(value = "数据中心-更新时间")
    private LocalDateTime gmtModified;

    @ApiModelProperty(value = "正常为0, 缺货为1")
    private Integer status;

    @ApiModelProperty(value = "缺货数量")
    private Integer quantityOutStock;

    @ApiModelProperty(value = "SKU标题")
    private String skuTitle;

    @ApiModelProperty(value = "与dc_auto_config_promotion的id关联,以逗号分隔")
    private String promotions;

    @ApiModelProperty(value = "供应商交期天数")
    private Integer supplierDelivery;

    @ApiModelProperty(value = "库存消化(可用)天数")
    private Integer inventoryAvailableDays;

    @ApiModelProperty(value = "周转期内入库数")
    private Integer quantityInbound;

    @ApiModelProperty(value = "预测第一日销量（日均)")
    private BigDecimal forecastOnedaySales;

    @ApiModelProperty(value = "预测第七日销量（日均)")
    private BigDecimal forecastSevendaySales;

    @ApiModelProperty(value = "预测第十四日销量（日均)")
    private BigDecimal forecastFourteendaySales;

    @ApiModelProperty(value = "七天实际销量+预测销量")
    private String salesDetails;

    @ApiModelProperty(value = "七天实际入库+预测入库")
    private String inboundDetails;

    @ApiModelProperty(value = "七天实际库存+预测库存")
    private String inventoryDetails;

    @ApiModelProperty(value = "七天实际断货+预测断货")
    private String shortSupplyDetails;

    @ApiModelProperty(value = "预测建议")
    private String advisedDetails;

    @ApiModelProperty(value = "销量上限")
    private BigDecimal salesUpperLimit;

    @ApiModelProperty(value = "供应商平均逾期")
    private BigDecimal averageOverdue;

    @ApiModelProperty(value = "供应商平均交期")
    private Integer averageSupplierDelivery;

    @ApiModelProperty(value = "调拨头程天数-配置")
    private Integer transferConfigDelivery;

    @ApiModelProperty(value = "调拨打包天数-配置")
    private Integer transferBaleConfigDelivery;

    @ApiModelProperty(value = "海外仓入库天数-配置")
    private Integer abroadInboundConfigDelivery;

    @ApiModelProperty(value = "质检入库天数-配置")
    private Integer inspectionConfigDelivery;

    @ApiModelProperty(value = "质检入库天数-最终取值")
    private Integer inspectionDelivery;

    @ApiModelProperty(value = "调拨头程天数-最终取值")
    private Integer transferDelivery;

    @ApiModelProperty(value = "调拨打包天数-最终取值")
    private Integer transferBaleDelivery;

    @ApiModelProperty(value = "海外仓入库天数-最终取值")
    private Integer abroadInboundDelivery;

    @ApiModelProperty(value = "补充销量, 当日销量")
    private BigDecimal supplementarySales;

    @ApiModelProperty(value = "周转期内总销量")
    private BigDecimal turnoverSales;

    @ApiModelProperty(value = "周转期内总入库")
    private BigDecimal turnoverInbound;

    @ApiModelProperty(value = "过去7日销量（日均)")
    private BigDecimal historySevendaySales;

    @ApiModelProperty(value = "过去14日销量（日均)")
    private BigDecimal historyFourteendaySales;

    @ApiModelProperty(value = "过去30日销量（日均)")
    private BigDecimal historyThirtydaySales;

    @ApiModelProperty(value = "预测销量及说明")
    private String salesExplainDetails;

    @ApiModelProperty(value = "预测周转期内平均销量")
    private BigDecimal forecastTurnoverdaySales;

    @ApiModelProperty(value = "备货天数的额外销量")
    private BigDecimal stockUpSales;

    @ApiModelProperty(value = "算备货销量前的初始建议数")
    private BigDecimal quantityBeginAdvise;

    @ApiModelProperty(value = "备货天数")
    private Integer stockUpDays;

    @ApiModelProperty(value = "先款后货情况供应商交期加的天数")
    private Integer paymentBeforeDelivery;

    @ApiModelProperty(value = "商品编码")
    private String productCode;

    @ApiModelProperty(value = "内部商品编码")
    private String productInnerCode;

    @ApiModelProperty(value = "分类id")
    private Integer bailunCategoryId;

    @ApiModelProperty(value = "采购员名称")
    private String buyerName;

    @ApiModelProperty(value = "供应商")
    private String suppliersName;

    @ApiModelProperty(value = "Ebay过去7日销量（日均)")
    private BigDecimal historySevendaySalesEbay;

    @ApiModelProperty(value = "Ebay过去14日销量（日均)")
    private BigDecimal historyFourteendaySalesEbay;

    @ApiModelProperty(value = "Ebay过去30日销量（日均)")
    private BigDecimal historyThirtydaySalesEbay;

    @ApiModelProperty(value = "aliexpress过去7日销量（日均)")
    private BigDecimal historySevendaySalesAliexpress;

    @ApiModelProperty(value = "aliexpress过去14日销量（日均)")
    private BigDecimal historyFourteendaySalesAliexpress;

    @ApiModelProperty(value = "aliexpress过去30日销量（日均)")
    private BigDecimal historyThirtydaySalesAliexpress;

    @ApiModelProperty(value = "日均加权销量")
    private BigDecimal dailyWeightedSales;

    @ApiModelProperty(value = "原始初始建议")
    private Integer originalQuantityInitAdvise;

    @ApiModelProperty(value = "是否有修改了建议数")
    private Integer isModifyQuantityInitAdvise;

    @ApiModelProperty(value = "dc_auto_jit_tag , id")
    private Integer tagId;

    @ApiModelProperty(value = "仓库类型")
    private String hqType;

    @ApiModelProperty(value = "amazon过去7日销量（日均)")
    private BigDecimal historySevendaySalesAmazon;

    @ApiModelProperty(value = "amazon过去14日销量（日均)")
    private BigDecimal historyFourteendaySalesAmazon;

    @ApiModelProperty(value = "amazon过去30日销量（日均)")
    private BigDecimal historyThirtydaySalesAmazon;

    @ApiModelProperty(value = "命中的销量预测规则id")
    private Integer dcAutoSalesForecastConfigId;

    @ApiModelProperty(value = "是否断货，1：是，0：否 （废弃）")
    private Integer isOutStock;

    @ApiModelProperty(value = "销量预测公式")
    private String salesDetailsFormula;


}
