package com.bailuntec.job.service;

import com.bailuntec.domain.DcJobConfig;
import com.bailuntec.infrastructure.mapper.DcBaseStockMapper;
import com.bailuntec.infrastructure.mapper.DcJobConfigMapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/10/7 11:38 上午
 */
@Service
public class TurnoverPrepareService {

    @Resource
    DcJobConfigMapper dcJobConfigMapper;

    private static final String midAutoTurnoverPrepare = "mid-auto-turnover-prepare";

    @Resource
    private DcBaseStockMapper dcBaseStockMapper;

    @Transactional
    public void syncBaseStock() {
        DcJobConfig dcJobConfig = dcJobConfigMapper.selectByName(midAutoTurnoverPrepare);
        dcBaseStockMapper.supplementOrderSku();
        dcBaseStockMapper.supplementPurchaseSku();
        dcBaseStockMapper.supplementTransitSku();

        dcJobConfigMapper.updateById(dcJobConfig.refresh());
    }
}
