package com.bailuntec.job;


import com.bailuntec.job.service.SyncCashierService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

@Slf4j
@Component
public class CashierJob {

    @Resource
    SyncCashierService syncCashierService;

    /**
     * 每秒同步流水
     */
    @Scheduled(cron = "0/5 * * * * ?")
    public void syncCashier() {
        try {
            log.info("每秒同步流水 开始");
            syncCashierService.syncCashier();
            log.info("每秒同步流水 结束");
        } catch (Exception ex) {
            log.error("每秒同步流水 异常:", ex);
        }
    }

    /**
     * 每秒同步流水
     */
    @Scheduled(cron = "0/5 * * * * ?")
    public void syncWithdraw() {
        try {
            log.info("每秒同步流水详情 开始");
            syncCashierService.syncWithdraw();
            log.info("每秒同步流水详情 结束");
        } catch (Exception ex) {
            log.error("每秒同步流水详情 异常:", ex);
        }

    }


    /**
     * 每天12点同步销售平台流水
     */
    @Scheduled(cron = "0 0 12 * * ?")
    public void syncSalesPlatform() {
        syncCashierService.syncSalesPlatform();
    }


    /**
     * 每天9，12点同步利息支出
     */
    @Scheduled(cron = "0 0 9,12 * * ?")
    public void syncInterest() {
        syncCashierService.syncInterest();

    }

    /**
     * 每两小时同步财务手续费
     */
    @Scheduled(cron = "0 0 0/2 * * ?")
    public void syncHandleFee() {
        syncCashierService.syncHandleFee();

    }
}
