package com.bailuntec.job;

import com.bailuntec.application.IDcBaseFinanceAmazonAdProductService;
import com.bailuntec.application.IJobAmazonAdLogService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.time.LocalDateTime;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/9/24 2:38 下午
 */
@Component
@Slf4j
public class AmazonAdJob {

    @Resource
    private IJobAmazonAdLogService jobAmazonAdLogService;
    @Resource
    private IDcBaseFinanceAmazonAdProductService dcBaseFinanceAmazonAdProductService;

    /**
     * <p>
     * 每天下午1点生成昨天的亚马逊广告报告
     * </p>
     */
    @Scheduled(cron = "0 0 13 * * ?")
    public void generateAmazonAdReport() {
        log.info("每天下午1点生成昨天的亚马逊广告报告 任务开始");
        jobAmazonAdLogService.generateAmazonAdReport();
        log.info("每天下午1点生成昨天的亚马逊广告报告 任务结束");
    }

    /**
     * <p>
     * 每小时下载未下载的报告
     * </p>
     */
    @Scheduled(cron = "0 1 0/1 * * ?")
    public void downloadAmazonAdReport() {
        log.info("每小时下载未下载的报告 任务开始");
        dcBaseFinanceAmazonAdProductService.downloadAmazonAdReport();
        log.info("每小时下载未下载的报告 任务结束");
    }


}
