package com.blt.other.module.cost.service.impl;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.bailuntec.common.ListUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.blt.other.common.config.property.CostUrlProperties;
import com.blt.other.common.util.CompanyUtil;
import com.blt.other.database.model.CostCompanyDomain;
import com.blt.other.module.auth.dao.OaUserMapper;
import com.blt.other.module.auth.model.OaUser;
import com.blt.other.module.cost.dao.CostCompanyDao;
import com.blt.other.module.cost.service.CostCompanyService;
import com.blt.other.module.purchasing.vo.CompanyVo;
import com.blt.other.module.sys.dao.CostReviewerMapper;
import com.blt.other.module.sys.dto.request.CompanyReviewerListReq;
import com.blt.other.module.sys.dto.request.CostReviewerExportReq;
import com.blt.other.module.sys.dto.request.CostReviewerImportItem;
import com.blt.other.module.sys.dto.request.CostReviewerImportReq;
import com.blt.other.module.sys.dto.response.CostReviewerExportItem;
import com.blt.other.module.sys.model.CostReviewer;
import com.blt.other.module.sys.service.impl.CostReviewerImportItemListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import springfox.documentation.annotations.Cacheable;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;

@Service
public class CostCompanyServiceImpl extends ServiceImpl<CostCompanyDao, CostCompanyDomain> implements CostCompanyService {
    private static Logger logger = LoggerFactory.getLogger(CostCompanyServiceImpl.class);
    @Resource
    private CostCompanyDao costCompanyDao;
    @Resource
    CostReviewerMapper costReviewerMapper;
    @Resource
    OaUserMapper oaUserMapper;
    @Resource
    CostUrlProperties costUrlProperties;

    @Override
    public String syncCompany() {

        List<CompanyVo> companyList = CompanyUtil.getCompanyList(costUrlProperties.postCompanyListApi);
        int result = 0;
        Integer update = 0;
        if (companyList != null && companyList.size() >= 1) {
            CostCompanyDomain companyDomain = null;
            for (CompanyVo companyVo : companyList) {
                // 根据公司名称判断是否已经存在公司主体
                companyDomain = new CostCompanyDomain();
                companyDomain.setValue(companyVo.getValue());
                companyDomain.setCompanyName(companyVo.getName());
                companyDomain.setCompanySystem(companyVo.getCompanySystem());
                List<CostCompanyDomain> costCompanyDomains = costCompanyDao.selectByNameOrValue(companyDomain);
                if (null != costCompanyDomains && costCompanyDomains.size() >= 1) {
                    // 如果表中已存在相同名称的主体，则 update（根据 companyNo）
                    String companyNo = costCompanyDomains.get(0).getCompanyNo();
                    companyDomain.setCompanyNo(companyNo);
                    if (isUpdate(costCompanyDomains.get(0), companyDomain)) {
                        //companyDomain.setCompanyNo(companyVo.getCodeName());
                        Integer Integer = costCompanyDao.update(companyDomain);
                        update += Integer;
                        if (Integer >= 1) {
                            logger.warn("主体" + companyDomain + "已更新费用管理系统记录");
                        }
                    }
                } else {
                    companyDomain.setCompanyNo(createCompanyNo());
                    companyDomain.setCodeName(companyVo.getCodeName());
                    costCompanyDao.insertCompany(companyDomain);
                    result += 1;
                    logger.warn("主体：" + companyDomain + " 已加入费用管理系统");
                }
            }
        }
        return "新增 " + result + " 条记录，更新 " + update + " 条记录";
    }

    @Override
    public List<CostCompanyDomain> getAllCompany() {
        return costCompanyDao.selectAll();
    }

    @Override
    public List<CostCompanyDomain> getAllCompanyAuthority() {
        return costCompanyDao.getAllCompanyAuthority();
    }

    private void setCostCompany(List<CostCompanyDomain> costCompanyDomainList) {
        if (ListUtil.isNotEmpty(costCompanyDomainList)) {
            List<Integer> costCompanyIds = costCompanyDomainList.stream().map(CostCompanyDomain::getId).collect(Collectors.toList());

            //最终审核人
            List<CostReviewer> finalCostReviewerList = costReviewerMapper.selectList(new LambdaQueryWrapper<CostReviewer>()
                    .in(CostReviewer::getReferId, costCompanyIds)
                    .eq(CostReviewer::getType, CostReviewer.finalReviewer));

            Map<Integer, CostReviewer> finalReviewerMap = finalCostReviewerList.stream().collect(Collectors.toMap(CostReviewer::getReferId, costReviewer -> costReviewer));
            costCompanyDomainList.forEach(record -> record.setFinalReviewer(finalReviewerMap.get(record.getId())));

            //财务审核人
            List<CostReviewer> financialCostReviewerList = costReviewerMapper.selectList(new LambdaQueryWrapper<CostReviewer>()
                    .in(CostReviewer::getReferId, costCompanyIds)
                    .eq(CostReviewer::getType, CostReviewer.financialReviewer));

            Map<Integer, List<CostReviewer>> financialReviewerMap = financialCostReviewerList.stream().collect(Collectors.groupingBy(CostReviewer::getReferId));
            costCompanyDomainList.forEach(record -> {
                record.setFinancialReviewer(financialReviewerMap.get(record.getId()));
            });

            //行政审核人
            List<CostReviewer> hrCostReviewerList = costReviewerMapper.selectList(new LambdaQueryWrapper<CostReviewer>()
                    .in(CostReviewer::getReferId, costCompanyIds)
                    .eq(CostReviewer::getType, CostReviewer.hrReviewer));

            Map<Integer, List<CostReviewer>> htReviewerMap = hrCostReviewerList.stream().collect(Collectors.groupingBy(CostReviewer::getReferId));
            costCompanyDomainList.forEach(record -> {
                record.setHrReviewer(htReviewerMap.get(record.getId()));
            });
        }

    }

    @Override
    public IPage<CostCompanyDomain> reviewerList(CompanyReviewerListReq req) {

        IPage<CostCompanyDomain> page = new Page<>(req.getPageNum(), req.getPageSize());

        page = baseMapper.reviewerPage(page, req);
        this.setCostCompany(page.getRecords());
        return page;
    }

    @Override
    public void modifyFinalReviewer(Integer userId, List<String> companyNoList, Integer finalReviewerUserId) {

        companyNoList.forEach(companyNo -> {
            OaUser currentOaUser = oaUserMapper.selectByOaUserId(userId);
            CostCompanyDomain costCompanyDomain = baseMapper.selectByNo(companyNo);

            //记录更新时间
            costCompanyDomain.setLastUpdateTime(LocalDateTime.now());
            costCompanyDomain.setUpdateUserId(userId);
            costCompanyDomain.setUpdateUserName(currentOaUser.getUserName());
            baseMapper.updateById(costCompanyDomain);


            //删除旧审核人
            costReviewerMapper.delete(new LambdaQueryWrapper<CostReviewer>()
                    .eq(CostReviewer::getType, CostReviewer.finalReviewer)
                    .eq(CostReviewer::getReferId, costCompanyDomain.getId()));


            //新增审核人
            OaUser oaUser = oaUserMapper.selectByOaUserId(finalReviewerUserId);
            CostReviewer costReviewer = CostReviewer.builder()
                    .reviewerUserId(finalReviewerUserId)
                    .reviewerUserName(oaUser.getUserName())
                    .referId(costCompanyDomain.getId())
                    .type(CostReviewer.finalReviewer)
                    .build();

            costReviewerMapper.insert(costReviewer);
        });
    }

    @Override
    public void modifyFinancialReviewer(Integer userId, List<String> companyNoList, List<Integer> financialReviewerUserIdList) {

        companyNoList.forEach(companyNo -> {
            OaUser currentOaUser = oaUserMapper.selectByOaUserId(userId);
            CostCompanyDomain costCompanyDomain = baseMapper.selectByNo(companyNo);

            //记录更新时间
            costCompanyDomain.setLastUpdateTime(LocalDateTime.now());
            costCompanyDomain.setUpdateUserId(userId);
            costCompanyDomain.setUpdateUserName(currentOaUser.getUserName());
            baseMapper.updateById(costCompanyDomain);

            //删除旧审核人
            costReviewerMapper.delete(new LambdaQueryWrapper<CostReviewer>()
                    .eq(CostReviewer::getType, CostReviewer.financialReviewer)
                    .eq(CostReviewer::getReferId, costCompanyDomain.getId()));

            financialReviewerUserIdList.forEach(financialReviewerUserId -> {
                //新增审核人
                OaUser financialReviewerOaUser = oaUserMapper.selectByOaUserId(financialReviewerUserId);
                CostReviewer costReviewer = CostReviewer.builder()
                        .reviewerUserId(financialReviewerUserId)
                        .reviewerUserName(financialReviewerOaUser.getUserName())
                        .referId(costCompanyDomain.getId())
                        .type(CostReviewer.financialReviewer)
                        .build();

                costReviewerMapper.insert(costReviewer);
            });
        });


    }

    @Override
    public void modifyHrReviewer(Integer userId, List<String> companyNoList, List<Integer> hrReviewerUserIdList) {
        companyNoList.forEach(companyNo -> {
            OaUser currentOaUser = oaUserMapper.selectByOaUserId(userId);
            CostCompanyDomain costCompanyDomain = baseMapper.selectByNo(companyNo);

            //记录更新时间
            costCompanyDomain.setLastUpdateTime(LocalDateTime.now());
            costCompanyDomain.setUpdateUserId(userId);
            costCompanyDomain.setUpdateUserName(currentOaUser.getUserName());
            baseMapper.updateById(costCompanyDomain);

            //删除旧审核人
            costReviewerMapper.delete(new LambdaQueryWrapper<CostReviewer>()
                    .eq(CostReviewer::getType, CostReviewer.hrReviewer)
                    .eq(CostReviewer::getReferId, costCompanyDomain.getId()));

            hrReviewerUserIdList.forEach(hrReviewerUserId -> {
                //新增审核人
                OaUser financialReviewerOaUser = oaUserMapper.selectByOaUserId(hrReviewerUserId);
                CostReviewer costReviewer = CostReviewer.builder()
                        .reviewerUserId(hrReviewerUserId)
                        .reviewerUserName(financialReviewerOaUser.getUserName())
                        .referId(costCompanyDomain.getId())
                        .type(CostReviewer.hrReviewer)
                        .build();

                costReviewerMapper.insert(costReviewer);
            });
        });
    }

    @Cacheable("costCompanyMap")
    @Override
    public Map<String, CostCompanyDomain> costCompanyMap() {
        return this.list().stream().collect(Collectors.toMap(CostCompanyDomain::getCompanyName, costCompanyDomain -> costCompanyDomain));
    }

    @Override
    public void importExcel(CostReviewerImportReq req) throws IOException {
        CostReviewerImportItemListener listener = new CostReviewerImportItemListener();
        EasyExcel.read(req.getMultipartFile().getInputStream(), CostReviewerImportItem.class, listener).sheet().doRead();
    }

    @Override
    public void exportExcel(HttpServletResponse response, CostReviewerExportReq req) throws IOException {
        // 这里注意 有同学反应使用swagger 会导致各种问题，请直接用浏览器或者用postman
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding("utf-8");
//
        String fileName = URLEncoder.encode("模版", "UTF-8");
        response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".xlsx");
        LongestMatchColumnWidthStyleStrategy longestMatchColumnWidthStyleStrategy = new LongestMatchColumnWidthStyleStrategy();

        List<CostReviewerExportItem> aiList = baseMapper.costReviewerExportItemList(req);
        EasyExcel.write(response.getOutputStream(), CostReviewerExportItem.class)
                .sheet("sheet")
                .registerWriteHandler(longestMatchColumnWidthStyleStrategy)
                .doWrite(aiList);
    }

    /**
     * 生成唯一的主体编号
     *
     * @return
     */
    private String createCompanyNo() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyMMddHHmmss");
        Random random = new Random();
        String companyNo = "COM" + sdf.format(new Date()) + random.nextInt(9);
        CostCompanyDomain companyDomain = costCompanyDao.selectByNo(companyNo);
        while (null != companyDomain && null != companyDomain.getCompanyName()) {
            companyNo = "COM" + sdf.format(new Date()) + random.nextInt(9);
            companyDomain = costCompanyDao.selectByNo(companyNo);
        }
        return companyNo;
    }

    private boolean isUpdate(CostCompanyDomain exited, CostCompanyDomain forInsert) {
        String companyName = exited.getCompanyName();
        Integer value = exited.getValue();
        String companySystem = exited.getCompanySystem();
        String companyName1 = forInsert.getCompanyName();
        Integer value1 = forInsert.getValue();
        String companySystem1 = forInsert.getCompanySystem();
        if (("" + companyName).equals("" + companyName1) && value == value1 && ("" + companySystem).equals("" + companySystem1) ) {
            return false;
        }
        return true;
    }
}
