package com.bailuntec.cost.api.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

@Data
public class CostPlanTempDto {

    private Integer id; // 费用单表 id
    private String costPlanNo; // 费用计划编号
    private String tempNo; // 计划缓存编号

    private String filePath; // 文件地址
    private String fileName; // 文件名
    private BigDecimal amount; // 费用总金额
    private String costReason; // 付款理由

    private String typeNo; // 大类编号
    private String typeNameDto; // 大类标题
    private String typeInnerName; // 内部分类
    private String dic; // 币种
    private String project; // 所属项目
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date projectDate; // 所属账期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date projectDateA; // 所属账期

    @ApiModelProperty("会计一级科目")
    private String accountingSubjectNo;
    @ApiModelProperty("会计一级科目")
    private String accountingSubjectName;

    private String lendType;

    @ApiModelProperty("项目")
    private String projectType;

    @ApiModelProperty("客户编号")
    private String customerNum;

}

